/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyEntity;
import com.biz.crm.sfa.business.attendance.local.model.FillApplyConditionModel;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceFillApplyRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceFillApplyPictureService;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceFillApplyService;
import com.biz.crm.sfa.business.attendance.sdk.constant.AttendanceConstant;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillClockDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.StartProcessDto;
import com.biz.crm.workflow.sdk.listener.ProcessListener;
import com.biz.crm.workflow.sdk.vo.response.CommitWorkflowResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceFillApplyService")
public class AttendanceFillApplyServiceImpl
implements AttendanceFillApplyService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceFillApplyServiceImpl.class);
    @Autowired
    private AttendanceFillApplyRepository attendanceFillApplyRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AttendanceRecordRepository attendanceRecordRepository;
    @Autowired
    private AttendanceFillApplyPictureService attendanceFillApplyPictureService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private UserFeignVoService userFeignVoService;

    @Override
    @Transactional
    public AttendanceFillApplyEntity create(AttendanceFillClockDto dto) {
        this.createValidation(dto);
        this.validateRecord(dto);
        AttendanceFillApplyEntity entity = (AttendanceFillApplyEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AttendanceFillApplyEntity.class, HashSet.class, ArrayList.class, new String[]{"recordIds"}));
        entity.setRecordIds(String.join((CharSequence)",", dto.getRecordIds()));
        entity.setApplyCode((String)this.generateCodeService.generateCode("FA", 1).get(0));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
        List userVoList = this.userFeignVoService.findByUserNames(Collections.singletonList(dto.getUserName()));
        if (!CollectionUtils.isEmpty((Collection)userVoList)) {
            Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
            UserVo userVo = userMap.get(dto.getUserName());
            entity.setUserRealName(userVo.getFullName());
            entity.setOrgCode(userVo.getOrgCode());
            entity.setOrgName(userVo.getOrgName());
            entity.setPositionCode(userVo.getPositionCode());
            entity.setPositionName(userVo.getPositionName());
        }
        this.attendanceFillApplyRepository.save((Object)entity);
        dto.setId(entity.getId());
        dto.setApplyCode(entity.getApplyCode());
        this.attendanceFillApplyPictureService.update(dto);
        entity.setProcessNumber(this.commitProcess(dto));
        this.attendanceFillApplyRepository.updateById((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public AttendanceFillApplyEntity update(AttendanceFillClockDto dto) {
        AttendanceFillApplyEntity entity;
        this.updateValidation(dto);
        this.validateRecord(dto);
        AttendanceFillApplyEntity applyEntity = (AttendanceFillApplyEntity)((Object)this.attendanceFillApplyRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)applyEntity), (String)"\u8865\u6253\u5361\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((ActApproveStatusEnum.REJECTED.getCode().equals(applyEntity.getProcessStatus()) || ActApproveStatusEnum.INTERRUPT.getCode().equals(applyEntity.getProcessStatus()) ? 1 : 0) != 0, (String)"\u8be5\u7533\u8bf7\u4e0d\u652f\u6301\u7f16\u8f91", (Object[])new Object[0]);
        if (ActApproveStatusEnum.REJECTED.getCode().equals(applyEntity.getProcessStatus())) {
            dto.setId(null);
        }
        entity.setApplyCode(StringUtils.isNotBlank((CharSequence)(entity = (AttendanceFillApplyEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AttendanceFillApplyEntity.class, HashSet.class, ArrayList.class, new String[]{"recordIds"}))).getId()) ? applyEntity.getApplyCode() : (String)this.generateCodeService.generateCode("FA", 1).get(0));
        entity.setRecordIds(String.join((CharSequence)",", dto.getRecordIds()));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
        List userVoList = this.userFeignVoService.findByUserNames(Collections.singletonList(dto.getUserName()));
        if (!CollectionUtils.isEmpty((Collection)userVoList)) {
            Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
            UserVo userVo = userMap.get(dto.getUserName());
            entity.setUserRealName(userVo.getFullName());
            entity.setOrgCode(userVo.getOrgCode());
            entity.setOrgName(userVo.getOrgName());
            entity.setPositionCode(userVo.getPositionCode());
            entity.setPositionName(userVo.getPositionName());
        }
        this.attendanceFillApplyRepository.saveOrUpdate((Object)entity);
        dto.setId(entity.getId());
        dto.setApplyCode(entity.getApplyCode());
        this.attendanceFillApplyPictureService.update(dto);
        entity.setProcessNumber(this.commitProcess(dto));
        this.attendanceFillApplyRepository.updateById((Object)entity);
        return entity;
    }

    private String commitProcess(AttendanceFillClockDto dto) {
        StartProcessDto startProcessDto = new StartProcessDto();
        startProcessDto.setProcessKey("fill_clock_apply_process001");
        startProcessDto.setBusinessId(dto.getId());
        startProcessDto.setBusinessNo(dto.getApplyCode());
        startProcessDto.setRemark(dto.getProcessRemark());
        startProcessDto.setFormType("attendance_fill_clock_apply");
        startProcessDto.setProcessTitle("\u8003\u52e4\u8865\u6253\u5361\u5ba1\u6279\u6d41\u7a0b");
        startProcessDto.setMenuCode(dto.getCompetenceCode());
        SerializableBiConsumer & Serializable sf = ProcessListener::onStartProcess;
        CommitWorkflowResponse response = (CommitWorkflowResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)startProcessDto, ProcessListener.class, (SerializableBiConsumer)sf);
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)response.getProcessInstanceId()), (String)"\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25\uff01", (Object[])new Object[0]);
        return response.getProcessInstanceId();
    }

    private void validateRecord(AttendanceFillClockDto dto) {
        List recordEntities = this.attendanceRecordRepository.listByIds(dto.getRecordIds());
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)recordEntities) && recordEntities.size() == Sets.newHashSet((Iterable)dto.getRecordIds()).size() ? 1 : 0) != 0, (String)"\u76f8\u5173\u6253\u5361\u8bb0\u5f55\u4e0d\u5339\u914d", (Object[])new Object[0]);
        recordEntities.forEach(entity -> {
            Validate.isTrue((boolean)entity.getUserName().equals(dto.getUserName()), (String)"\u4e0d\u80fd\u7533\u8bf7\u975e\u81ea\u8eab\u6253\u5361\u8bb0\u5f55", (Object[])new Object[0]);
            Validate.isTrue((!AttendanceClockStatus.OK.getDictCode().equals(entity.getClockStatus()) ? 1 : 0) != 0, (String)String.format("%s(%s),\u4e0d\u662f\u5f02\u5e38\u6253\u5361,\u65e0\u9700\u7533\u8bf7", AttendanceClockType.getByDictCode((String)entity.getClockType()).getValue(), entity.getRuleClockTime()), (Object[])new Object[0]);
            Validate.isTrue((entity.getRuleDate().compareTo(dto.getBeginTime()) >= 0 && entity.getRuleDate().compareTo(dto.getEndTime()) <= 0 ? 1 : 0) != 0, (String)String.format("%s(%s),\u6253\u5361\u65e5\u671f\u4e0e\u6240\u9009\u65e5\u671f\u4e0d\u5339\u914d", AttendanceClockType.getByDictCode((String)entity.getClockType()).getValue(), entity.getRuleClockTime()), (Object[])new Object[0]);
        });
        FillApplyConditionModel model = new FillApplyConditionModel();
        model.setBeginTime(dto.getBeginTime());
        model.setEndTime(dto.getEndTime());
        model.setTenantCode(dto.getTenantCode());
        model.setUserName(dto.getUserName());
        model.setExcludeProcessStatusList(Lists.newArrayList((Object[])new String[]{ActApproveStatusEnum.REJECTED.getCode(), ActApproveStatusEnum.INTERRUPT.getCode()}));
        List<AttendanceFillApplyEntity> applyEntities = this.attendanceFillApplyRepository.findByFillApplyConditionModel(model);
        if (CollectionUtils.isEmpty(applyEntities)) {
            return;
        }
        List existsRecordIdList = applyEntities.stream().filter(entity -> !entity.getId().equals(dto.getId())).collect(Collectors.toList()).stream().flatMap(attendanceFillApplyEntity -> Lists.newArrayList((Object[])attendanceFillApplyEntity.getRecordIds().split(",")).stream()).collect(Collectors.toList());
        existsRecordIdList.retainAll(dto.getRecordIds());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(existsRecordIdList), (String)"\u5b58\u5728\u76f8\u5173\u7684\u8865\u6253\u5361\u7533\u8bf7", (Object[])new Object[0]);
    }

    private void createValidation(AttendanceFillClockDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getBeginTime(), (String)"\u7f3a\u5931\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEndTime(), (String)"\u7f3a\u5931\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getRecordIds()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u5f02\u5e38\u6253\u5361\u8bb0\u5f55", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getBeginTime()), (String)"\u975e\u6cd5\u7684\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getEndTime()), (String)"\u975e\u6cd5\u7684\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((dto.getBeginTime().compareTo(dto.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        LocalDate nowDate = LocalDate.now();
        dto.setApplyDate(LocalDateTime.now().format(AttendanceConstant.YYYY_MM_DD_HH_MM_SS));
        Validate.isTrue((dto.getEndTime().compareTo(nowDate.format(AttendanceConstant.YYYY_MM_DD)) < 0 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u62a5\u5907\u5f53\u5929\u4e4b\u524d\u7684\u5f02\u5e38\u6253\u5361", (Object[])new Object[0]);
        if (nowDate.getDayOfMonth() > AttendanceConstant.FILL_CLOCK_CAN_UPDATE_LAST_MONTH_DAY_NUM) {
            Validate.isTrue((!LocalDate.parse(dto.getBeginTime()).isBefore(LocalDate.of(nowDate.getYear(), nowDate.getMonth(), 1)) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u62a5\u5907\u5f53\u6708\u5f02\u5e38\u6253\u5361", (Object[])new Object[0]);
        } else {
            LocalDate ult = nowDate.minusMonths(1L);
            Validate.isTrue((!LocalDate.parse(dto.getBeginTime()).isBefore(LocalDate.of(ult.getYear(), ult.getMonth(), 1)) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u62a5\u5907\u4e0a\u6708\u5f02\u5e38\u7b7e\u5230", (Object[])new Object[0]);
        }
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setUserName(loginDetails.getAccount());
    }

    private void updateValidation(AttendanceFillClockDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBeginTime(), (String)"\u7f3a\u5931\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEndTime(), (String)"\u7f3a\u5931\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getRecordIds()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u5f02\u5e38\u6253\u5361\u8bb0\u5f55", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getBeginTime()), (String)"\u975e\u6cd5\u7684\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getEndTime()), (String)"\u975e\u6cd5\u7684\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((dto.getBeginTime().compareTo(dto.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        LocalDate nowDate = LocalDate.now();
        dto.setApplyDate(LocalDateTime.now().format(AttendanceConstant.YYYY_MM_DD_HH_MM_SS));
        Validate.isTrue((dto.getEndTime().compareTo(dto.getApplyDate()) < 0 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u62a5\u5907\u5f53\u5929\u4e4b\u524d\u7684\u5f02\u5e38\u6253\u5361", (Object[])new Object[0]);
        if (nowDate.getDayOfMonth() > AttendanceConstant.FILL_CLOCK_CAN_UPDATE_LAST_MONTH_DAY_NUM) {
            Validate.isTrue((!LocalDate.parse(dto.getBeginTime()).isBefore(LocalDate.of(nowDate.getYear(), nowDate.getMonth(), 1)) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u62a5\u5907\u5f53\u6708\u5f02\u5e38\u6253\u5361", (Object[])new Object[0]);
        } else {
            LocalDate ult = nowDate.minusMonths(1L);
            Validate.isTrue((!LocalDate.parse(dto.getBeginTime()).isBefore(LocalDate.of(ult.getYear(), ult.getMonth(), 1)) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u62a5\u5907\u4e0a\u6708\u5f02\u5e38\u7b7e\u5230", (Object[])new Object[0]);
        }
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setUserName(loginDetails.getAccount());
    }
}

