/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceFillApplyRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRepository;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillApplyPageDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceFillApplyVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceFillApplyVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AttendanceFillApplyVoServiceImpl
implements AttendanceFillApplyVoService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceFillApplyVoServiceImpl.class);
    @Autowired
    private AttendanceFillApplyRepository attendanceFillApplyRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AttendanceRecordRepository attendanceRecordRepository;
    @Autowired
    private UserFeignVoService userFeignVoService;
    @Autowired
    private PositionVoService positionVoService;
    @Autowired
    private UserInfoVoService userInfoVoService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private UserVoService userVoService;

    public List<AttendanceFillApplyVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newLinkedList();
        }
        List<AttendanceFillApplyEntity> entities = this.attendanceFillApplyRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        Set recordIds = entities.stream().filter(entity -> StringUtils.isNotBlank((CharSequence)entity.getRecordIds())).flatMap(entity -> Sets.newHashSet((Object[])entity.getRecordIds().split(",")).stream()).collect(Collectors.toSet());
        List recordEntities = this.attendanceRecordRepository.listByIds(recordIds);
        Map<Object, Object> recordMap = !CollectionUtils.isEmpty((Collection)recordEntities) ? recordEntities.stream().collect(Collectors.toMap(UuidEntity::getId, entity -> (AttendanceRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AttendanceRecordVo.class, HashSet.class, ArrayList.class, new String[0]), (a, b) -> b)) : Maps.newHashMap();
        List<AttendanceFillApplyVo> list = entities.stream().map(entity -> {
            AttendanceFillApplyVo vo = (AttendanceFillApplyVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, AttendanceFillApplyVo.class, HashSet.class, ArrayList.class, new String[0]);
            List recordList = Arrays.stream(entity.getRecordIds().split(",")).map(recordMap::get).filter(Objects::nonNull).collect(Collectors.toList());
            vo.setRecordList(recordList);
            return vo;
        }).collect(Collectors.toList());
        this.perfectUserInfo(list);
        return list;
    }

    public Page<AttendanceFillApplyVo> findByConditions(Pageable pageable, AttendanceFillApplyPageDto dto) {
        List userList;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (AttendanceFillApplyPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new AttendanceFillApplyPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setUserNames((Set)Sets.newHashSet((Object[])new String[]{loginDetails.getAccount()}));
        List positionList = this.positionVoService.findByParentCode(loginDetails.getPostCode());
        if (!CollectionUtils.isEmpty((Collection)positionList) && !CollectionUtils.isEmpty((Collection)(userList = this.userInfoVoService.findByPositionCodes(positionList.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet()))))) {
            dto.getUserNames().addAll(userList.stream().map(UserInfoVo::getUserName).collect(Collectors.toList()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getKeyWord())) {
            UserConditionDto userConditionDto = new UserConditionDto();
            userConditionDto.setFullName(dto.getKeyWord());
            dto.setKeyWordUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getApplyDateStart())) {
            dto.setApplyDateStart(String.format("%s %s", dto.getApplyDateStart(), "00:00:00"));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getApplyDateEnd())) {
            dto.setApplyDateEnd(String.format("%s %s", dto.getApplyDateEnd(), "23:59:59"));
        }
        Page<AttendanceFillApplyEntity> entityPage = this.attendanceFillApplyRepository.findByConditions(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entityPage.getRecords(), AttendanceFillApplyEntity.class, AttendanceFillApplyVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.perfectUserInfo(list);
        pageResult.setRecords(list);
        return pageResult;
    }

    public Page<AttendanceFillApplyVo> findDetailByConditions(Pageable pageable, AttendanceFillApplyPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (StringUtils.isNotBlank((CharSequence)(dto = (AttendanceFillApplyPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new AttendanceFillApplyPageDto())).getUserRealName())) {
            UserConditionDto userConditionDto = new UserConditionDto();
            userConditionDto.setFullName(dto.getUserRealName());
            dto.setUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isNotEmpty((CharSequence)dto.getApplyDateStart())) {
            dto.setApplyDateStart(String.format("%s %s", dto.getApplyDateStart(), "00:00:00"));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getApplyDateEnd())) {
            dto.setApplyDateEnd(String.format("%s %s", dto.getApplyDateEnd(), "23:59:59"));
        }
        Page<AttendanceFillApplyEntity> entityPage = this.attendanceFillApplyRepository.findByConditions(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entityPage.getRecords(), AttendanceFillApplyEntity.class, AttendanceFillApplyVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.perfectRecordInfo(list);
        pageResult.setRecords(list);
        return pageResult;
    }

    private void perfectUserInfo(List<AttendanceFillApplyVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set userNames = list.stream().map(AttendanceFillApplyVo::getUserName).collect(Collectors.toSet());
        List userVoList = this.userFeignVoService.findByUserNames((List)Lists.newArrayList(userNames));
        if (CollectionUtils.isEmpty((Collection)userVoList)) {
            return;
        }
        Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
        list.forEach(vo -> {
            UserVo userVo = userMap.getOrDefault(vo.getUserName(), new UserVo());
            vo.setUserRealName(userVo.getFullName());
            vo.setPositionCode(userVo.getPositionCode());
            vo.setPositionName(userVo.getPositionName());
            vo.setOrgCode(userVo.getOrgCode());
            vo.setOrgName(userVo.getOrgName());
        });
    }

    private void perfectRecordInfo(List<AttendanceFillApplyVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        HashSet recordIdSet = new HashSet();
        list.forEach(vo -> {
            String recordIds = vo.getRecordIds();
            if (StringUtils.isNotBlank((CharSequence)recordIds)) {
                String[] split;
                for (String s : split = recordIds.split(",")) {
                    recordIdSet.add(s);
                }
            }
        });
        List recordEntities = this.attendanceRecordRepository.listByIds(recordIdSet);
        if (CollectionUtils.isEmpty((Collection)recordEntities)) {
            return;
        }
        Map<String, AttendanceRecordEntity> attendanceRecordEntityMap = recordEntities.stream().collect(Collectors.toMap(UuidEntity::getId, t -> t, (a, b) -> b));
        list.forEach(vo -> {
            String recordIds = vo.getRecordIds();
            if (StringUtils.isNotBlank((CharSequence)recordIds)) {
                String[] split;
                for (String s : split = recordIds.split(",")) {
                    AttendanceRecordEntity attendanceRecordEntity = (AttendanceRecordEntity)((Object)((Object)attendanceRecordEntityMap.get(s)));
                    if (!Objects.nonNull((Object)attendanceRecordEntity)) continue;
                    String ruleDate = attendanceRecordEntity.getRuleDate();
                    String clockType = attendanceRecordEntity.getClockType();
                    AttendanceClockType attendanceClockType = AttendanceClockType.getByDictCode((String)clockType);
                    if (Objects.nonNull(attendanceClockType)) {
                        String value = attendanceClockType.getValue();
                        String clockTime = attendanceRecordEntity.getClockTime() == null ? "" : attendanceRecordEntity.getClockTime();
                        String clockTypeStr = String.format("%s (%s)", value, clockTime);
                        vo.setClockType(clockTypeStr);
                    }
                    vo.setRuleDate(ruleDate);
                }
            }
        });
    }
}

