/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordRuleEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordRulePlaceEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleSpecialDateEntity;
import com.biz.crm.sfa.business.attendance.local.model.RuleExecuteModel;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRulePlaceRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRuleRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRecordRuleService;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRecordService;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceSignOrNonType;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceSpecialDateType;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceRuleVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleVo;
import com.biz.crm.sfa.business.holiday.sdk.service.HolidayVoService;
import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceRecordRuleService")
public class AttendanceRecordRuleServiceImpl
implements AttendanceRecordRuleService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceRecordRuleServiceImpl.class);
    @Autowired
    private AttendanceRecordRuleRepository attendanceRecordRuleRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private HolidayVoService holidayVoService;
    @Autowired
    private AttendanceRecordService attendanceRecordService;
    @Autowired
    private AttendanceRuleVoService attendanceRuleVoService;
    @Autowired
    private AttendanceRecordRepository attendanceRecordRepository;
    @Autowired
    private AttendanceRecordRulePlaceRepository attendanceRecordRulePlaceRepository;

    @Override
    @Transactional
    public void create(RuleExecuteModel executeModel) {
        Validate.notNull((Object)executeModel, (String)"\u7f3a\u5931\u89c4\u5219\u6267\u884c\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(executeModel.getRuleMap()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8003\u52e4\u89c4\u5219\u4fe1\u606f", (Object[])new Object[0]);
        String executeDate = StringUtils.isNotBlank((CharSequence)executeModel.getExecuteDate()) ? executeModel.getExecuteDate() : LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        HolidayVo holidayVo = this.holidayVoService.findByDate(executeModel.getExecuteDate());
        this.attendanceRecordRepository.deleteByRuleDateAndUsedStatus(TenantUtils.getTenantCode(), executeDate, BooleanEnum.FALSE.getCapital());
        executeModel.getRuleMap().keySet().forEach(ruleId -> {
            AttendanceRuleEntity ruleEntity = executeModel.getRuleMap().get(ruleId);
            if (CollectionUtils.isEmpty((Collection)executeModel.getRuleUserMap().get(ruleId))) {
                log.info(String.format("\u89c4\u5219[%s],\u6ca1\u6709\u5bf9\u5e94\u7684\u89c4\u5219\u6267\u884c\u7528\u6237", ruleId));
                return;
            }
            AttendanceRuleVo attendanceRuleVo = this.attendanceRuleVoService.findById(ruleId);
            Validate.isTrue((Objects.nonNull(attendanceRuleVo) && Objects.nonNull((Object)ruleEntity) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8003\u52e4\u89c4\u5219\u4fe1\u606f", (Object[])new Object[0]);
            AttendanceRecordRuleEntity recordRuleEntity = (AttendanceRecordRuleEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)ruleEntity, AttendanceRecordRuleEntity.class, HashSet.class, ArrayList.class, new String[0])));
            recordRuleEntity.setId(null);
            recordRuleEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            recordRuleEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            recordRuleEntity.setRuleId(ruleEntity.getId());
            recordRuleEntity.setRuleCode(ruleEntity.getRuleCode());
            recordRuleEntity.setRuleDate(executeDate);
            recordRuleEntity.setRuleYear(executeDate.substring(0, 4));
            recordRuleEntity.setRuleMonth(executeDate.substring(6, 7));
            recordRuleEntity.setRuleYearMonth(executeDate.substring(0, 7));
            recordRuleEntity.setNoWorkAbideInfo(CollectionUtils.isEmpty((Collection)attendanceRuleVo.getNoWorkAbideInfoList()) ? null : JSON.toJSONString((Object)attendanceRuleVo.getNoWorkAbideInfoList()));
            this.buildSignInfo(holidayVo, ruleEntity, recordRuleEntity);
            this.attendanceRecordRuleRepository.save((Object)recordRuleEntity);
            if (!CollectionUtils.isEmpty((Collection)attendanceRuleVo.getPlaceList())) {
                List placeEntities = attendanceRuleVo.getPlaceList().stream().map(placeVo -> {
                    AttendanceRecordRulePlaceEntity recordRulePlaceEntity = (AttendanceRecordRulePlaceEntity)((Object)((Object)((Object)this.nebulaToolkitService.copyObjectByBlankList(placeVo, AttendanceRecordRulePlaceEntity.class, HashSet.class, ArrayList.class, new String[0]))));
                    recordRulePlaceEntity.setRecordRuleId(recordRuleEntity.getId());
                    recordRulePlaceEntity.setId(null);
                    return recordRulePlaceEntity;
                }).collect(Collectors.toList());
                this.attendanceRecordRulePlaceRepository.saveBatch(placeEntities);
            }
            this.attendanceRecordService.update(executeModel, recordRuleEntity);
        });
    }

    @Override
    @Transactional
    public void deleteByRuleIdsAndRuleDate(List<String> ruleIds, String ruleDate) {
        Validate.isTrue((!CollectionUtils.isEmpty(ruleIds) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8003\u52e4\u89c4\u5219ID", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ruleDate, (String)"\u7f3a\u5931\u8003\u52e4\u89c4\u5219\u65e5\u671f", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        this.attendanceRecordRuleRepository.deleteByRuleIdsAndRuleDate(tenantCode, ruleIds, ruleDate);
        this.attendanceRecordRepository.deleteByRuleIdsAndRuleDate(tenantCode, ruleIds, ruleDate);
    }

    private void buildSignInfo(HolidayVo holidayVo, AttendanceRuleEntity ruleEntity, AttendanceRecordRuleEntity recordRuleEntity) {
        List<AttendanceRuleSpecialDateEntity> specialDateList = ruleEntity.getSpecialDateList();
        if (Objects.nonNull(holidayVo) && BooleanEnum.TRUE.getCapital().equals(ruleEntity.getSyncHoliday())) {
            recordRuleEntity.setSignMust(BooleanEnum.FALSE.getCapital());
            recordRuleEntity.setSignOrNonType(AttendanceSignOrNonType.HOLIDAY_NO_SIGN.getDictCode());
            return;
        }
        if (!CollectionUtils.isEmpty(specialDateList) && !CollectionUtils.isEmpty(specialDateList = specialDateList.stream().filter(entity -> recordRuleEntity.getRuleDate().equals(entity.getSpecialDate())).collect(Collectors.toList()))) {
            AttendanceRuleSpecialDateEntity specialDateEntity = specialDateList.get(0);
            if (AttendanceSpecialDateType.MUST_CLOCK.getDictCode().equals(specialDateEntity.getSpecialDateType())) {
                recordRuleEntity.setSignMust(BooleanEnum.TRUE.getCapital());
                recordRuleEntity.setSignOrNonType(AttendanceSignOrNonType.SPECIAL_DAY_SIGN.getDictCode());
                return;
            }
            recordRuleEntity.setSignOrNonType(AttendanceSignOrNonType.SPECIAL_DAY_NO_SIGN.getDictCode());
        }
        int weekNo = LocalDate.now().getDayOfWeek().getValue();
        if (ruleEntity.getWorkingDay().contains(String.valueOf(weekNo))) {
            recordRuleEntity.setSignMust(BooleanEnum.TRUE.getCapital());
            if (StringUtils.isEmpty((CharSequence)recordRuleEntity.getSignOrNonType())) {
                recordRuleEntity.setSignOrNonType(AttendanceSignOrNonType.WORKDAY_SIGN.getDictCode());
            }
        } else {
            recordRuleEntity.setSignMust(BooleanEnum.FALSE.getCapital());
            if (StringUtils.isEmpty((CharSequence)recordRuleEntity.getSignOrNonType())) {
                recordRuleEntity.setSignOrNonType(AttendanceSignOrNonType.WORK_DAY_NO_SIGN.getDictCode());
            }
        }
    }
}

