/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.DistanceUtil;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordRuleEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordRulePlaceEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRulePlaceRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRuleRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordVoRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRecordPictureService;
import com.biz.crm.sfa.business.attendance.sdk.constant.AttendanceConstant;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceClockDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendancePlaceStatusDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.RuleNoWorkAbideDataDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.TodayHistoryRecordDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockTimeStatus;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceElectronFenceType;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceOffWorkClockType;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendancePlaceStatus;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleType;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceSignOrNonType;
import com.biz.crm.sfa.business.attendance.sdk.event.AttendanceRuleEventListener;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceRecordVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRecordVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleNoWorkAbideDataVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleNoWorkAbideVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AttendanceRecordVoServiceImpl
implements AttendanceRecordVoService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceRecordVoServiceImpl.class);
    @Autowired
    private AttendanceRecordRepository attendanceRecordRepository;
    @Autowired
    private AttendanceRecordVoRepository attendanceRecordVoRepository;
    @Autowired
    private AttendanceRecordRuleRepository attendanceRecordRuleRepository;
    @Autowired
    private AttendanceRecordRulePlaceRepository attendanceRecordRulePlaceRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AttendanceRecordPictureService attendanceRecordPictureService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private VisitPlanDetailVoService visitPlanDetailVoService;
    @Autowired
    private CustomerVoService customerVoService;
    @Autowired
    private TerminalVoService terminalVoService;
    @Autowired
    private UserInfoVoService userInfoVoService;
    @Autowired(required=false)
    private List<AttendanceRuleEventListener> listeners;

    public AttendanceRecordVo findByAttendanceClockDto(AttendanceClockDto dto) {
        AttendanceRecordVo attendanceRecordVo = new AttendanceRecordVo();
        attendanceRecordVo.setClockTimeStatus(AttendanceClockTimeStatus.NOT_CLOCK_TIME.getDictCode());
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getClockType())) {
            return attendanceRecordVo;
        }
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        List<AttendanceRecordEntity> recordEntities = this.attendanceRecordRepository.findByUserNameAndRuleDateAndClockType(TenantUtils.getTenantCode(), loginDetails.getAccount(), LocalDate.now().format(AttendanceConstant.YYYY_MM_DD), dto.getClockType());
        if (CollectionUtils.isEmpty(recordEntities)) {
            attendanceRecordVo.setClockTimeStatus(AttendanceClockTimeStatus.TODAY_NOT_NEED_CLOCK.getDictCode());
            return attendanceRecordVo;
        }
        String nowTime = LocalDateTime.now().format(AttendanceConstant.HH_MM_SS);
        Map<String, List<AttendanceRecordVo>> attendanceRecordMap = recordEntities.stream().sorted(Comparator.comparing(AttendanceRecordEntity::getRuleClockTime)).filter(entity -> nowTime.compareTo(entity.getRuleClockEndTime()) <= 0).map(this::buildAttendanceRecordVo).collect(Collectors.groupingBy(AttendanceRecordVo::getClockTimeStatus));
        List<AttendanceRecordVo> notNeedList = attendanceRecordMap.get(AttendanceClockTimeStatus.TODAY_NOT_NEED_CLOCK.getDictCode());
        List<AttendanceRecordVo> canList = attendanceRecordMap.get(AttendanceClockTimeStatus.CURRENT_CAN_CLOCK.getDictCode());
        List<AttendanceRecordVo> notTimeList = attendanceRecordMap.get(AttendanceClockTimeStatus.NOT_CLOCK_TIME.getDictCode());
        if (!CollectionUtils.isEmpty(canList)) {
            attendanceRecordVo = canList.get(0);
        } else if (!CollectionUtils.isEmpty(notTimeList)) {
            attendanceRecordVo = notTimeList.get(0);
        } else if (!CollectionUtils.isEmpty(notNeedList)) {
            attendanceRecordVo = notNeedList.get(0);
        }
        return attendanceRecordVo;
    }

    @Transactional
    public void updateByAttendanceClockDto(AttendanceClockDto dto) {
        Validate.notNull((Object)dto, (String)"\u7f3a\u5931\u8003\u52e4\u6253\u5361\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getClockType(), (String)"\u7f3a\u5931\u6253\u5361\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRecordId(), (String)"\u7f3a\u5931\u8003\u52e4\u8bb0\u5f55ID", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getClockLatitude(), (String)"\u7f3a\u5931\u5b9a\u4f4d\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getClockLongitude(), (String)"\u7f3a\u5931\u5b9a\u4f4d\u4fe1\u606f", (Object[])new Object[0]);
        AttendanceRecordEntity recordEntity = (AttendanceRecordEntity)((Object)this.attendanceRecordRepository.getById((Serializable)((Object)dto.getRecordId())));
        Validate.notNull((Object)((Object)recordEntity), (String)"\u8003\u52e4\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)dto.getClockType().equals(recordEntity.getClockType()), (String)"\u8003\u52e4\u6253\u5361\u7c7b\u578b\u4e0d\u5339\u914d", (Object[])new Object[0]);
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        Validate.isTrue((boolean)loginDetails.getAccount().equals(recordEntity.getUserName()), (String)"\u6253\u5361\u4eba\u4e0e\u6253\u5361\u8bb0\u5f55\u4e0d\u5339\u914d", (Object[])new Object[0]);
        AttendanceRecordRuleEntity recordRuleEntity = (AttendanceRecordRuleEntity)((Object)this.attendanceRecordRuleRepository.getById((Serializable)((Object)recordEntity.getRecordRuleId())));
        Validate.notNull((Object)((Object)recordEntity), (String)"\u8003\u52e4\u8bb0\u5f55\u89c4\u5219\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.validateRecord(dto, recordEntity, recordRuleEntity);
        String clockPlaceStatus = this.validatePlace(dto, recordRuleEntity, loginDetails);
        Validate.isTrue((!AttendancePlaceStatus.EX.getDictCode().equals(clockPlaceStatus) || !AttendanceElectronFenceType.NO_OUT_SIGN.getDictCode().equals(recordRuleEntity.getElectronFenceType()) ? 1 : 0) != 0, (String)"\u4e0d\u5141\u8bb8\u8003\u52e4\u8303\u56f4\u5916\u6253\u5361", (Object[])new Object[0]);
        this.buildClockStatus(recordEntity, recordRuleEntity);
        recordEntity.setClockPlaceStatus(clockPlaceStatus);
        recordEntity.setRemark(dto.getRemark());
        recordEntity.setExceptionRemarks(dto.getRemark());
        recordEntity.setClockPlace(dto.getClockPlace());
        recordEntity.setClockLongitude(dto.getClockLongitude());
        recordEntity.setClockLatitude(dto.getClockLatitude());
        this.attendanceRecordRepository.updateById((Object)recordEntity);
        this.attendanceRecordRepository.updateUsedStatusByUserNameAndRecordRuleId(recordEntity.getTenantCode(), recordEntity.getUserName(), recordEntity.getRecordRuleId(), BooleanEnum.TRUE.getCapital());
        this.attendanceRecordPictureService.update(dto);
    }

    public List<AttendanceRecordVo> findByTodayHistoryRecordDto(TodayHistoryRecordDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getClockType(), dto.getBeforeRecordId()})) {
            return Lists.newLinkedList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setUserName(loginDetails.getAccount());
        List<AttendanceRecordEntity> recordEntities = this.attendanceRecordRepository.findByTodayHistoryRecordDto(dto);
        if (CollectionUtils.isEmpty(recordEntities)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(recordEntities, AttendanceRecordEntity.class, AttendanceRecordVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<AttendanceRecordVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newLinkedList();
        }
        List<AttendanceRecordEntity> recordEntities = this.attendanceRecordRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(recordEntities)) {
            return Lists.newLinkedList();
        }
        List recordList = (List)this.nebulaToolkitService.copyCollectionByBlankList(recordEntities, AttendanceRecordEntity.class, AttendanceRecordVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildUserInfo(recordList);
        return recordList;
    }

    public AttendanceRecordVo findByAttendancePlaceStatusDto(AttendancePlaceStatusDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getRecordId())) {
            return null;
        }
        AttendanceRecordEntity recordEntity = (AttendanceRecordEntity)((Object)this.attendanceRecordRepository.getById((Serializable)((Object)dto.getRecordId())));
        if (Objects.isNull((Object)recordEntity)) {
            return null;
        }
        AttendanceRecordRuleEntity recordRuleEntity = (AttendanceRecordRuleEntity)((Object)this.attendanceRecordRuleRepository.getById((Serializable)((Object)recordEntity.getRecordRuleId())));
        if (Objects.isNull((Object)recordRuleEntity)) {
            return null;
        }
        AttendanceClockDto clockDto = (AttendanceClockDto)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, AttendanceClockDto.class, HashSet.class, ArrayList.class, new String[0]);
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        clockDto.setClockType(recordEntity.getClockType());
        AttendanceRecordVo recordVo = (AttendanceRecordVo)this.nebulaToolkitService.copyObjectByBlankList((Object)recordEntity, AttendanceRecordVo.class, HashSet.class, ArrayList.class, new String[0]);
        recordVo.setClockPlaceStatus(this.validatePlace(clockDto, recordRuleEntity, loginDetails));
        return recordVo;
    }

    public List<AttendanceRecordVo> findByHistoryRecordDto(TodayHistoryRecordDto dto) {
        if (Objects.isNull(dto)) {
            dto = new TodayHistoryRecordDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<AttendanceRecordVo> recordEntities = this.attendanceRecordVoRepository.findByHistoryRecordDto(dto);
        return recordEntities;
    }

    private void buildUserInfo(List<AttendanceRecordVo> recordList) {
        if (CollectionUtils.isEmpty(recordList)) {
            return;
        }
        Set userNames = recordList.stream().map(AttendanceRecordVo::getUserName).collect(Collectors.toSet());
        List userInfoList = this.userInfoVoService.findByUserNames(userNames);
        if (CollectionUtils.isEmpty((Collection)userInfoList)) {
            return;
        }
        Map<String, UserInfoVo> userInfoMap = userInfoList.stream().collect(Collectors.toMap(UserInfoVo::getUserName, t -> t, (a, b) -> b));
        recordList.forEach(attendanceRecordVo -> {
            UserInfoVo userInfoVo = userInfoMap.getOrDefault(attendanceRecordVo.getUserName(), new UserInfoVo());
            attendanceRecordVo.setUserRealName(userInfoVo.getFullName());
        });
    }

    private void buildClockStatus(AttendanceRecordEntity recordEntity, AttendanceRecordRuleEntity recordRuleEntity) {
        if (AttendanceClockType.ON_WORK.getDictCode().equals(recordEntity.getClockType()) && !AttendanceClockStatus.NONE.getDictCode().equals(recordEntity.getClockStatus())) {
            return;
        }
        String ruleDate = recordEntity.getRuleDate();
        LocalDateTime ruleClockTime = LocalDateTime.parse(String.format("%s %s", ruleDate, recordEntity.getRuleClockTime()), AttendanceConstant.YYYY_MM_DD_HH_MM_SS);
        LocalDateTime nowDateTime = LocalDateTime.now();
        String clockStatus = null;
        if (AttendanceRuleType.FREE_TIME.getDictCode().equals(recordRuleEntity.getRuleType())) {
            clockStatus = AttendanceClockStatus.OK.getDictCode();
        } else if (AttendanceClockType.ON_WORK.getDictCode().equals(recordEntity.getClockType())) {
            clockStatus = nowDateTime.compareTo(ruleClockTime) > 0 ? AttendanceClockStatus.BE_LATE.getDictCode() : AttendanceClockStatus.OK.getDictCode();
        } else if (AttendanceClockType.OFF_WORK.getDictCode().equals(recordEntity.getClockType())) {
            clockStatus = nowDateTime.compareTo(ruleClockTime) < 0 ? AttendanceClockStatus.LEAVE_EARLY.getDictCode() : AttendanceClockStatus.OK.getDictCode();
        }
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)clockStatus), (String)"\u6253\u5361\u72b6\u6001\u5f02\u5e38", (Object[])new Object[0]);
        recordEntity.setClockTime(nowDateTime.format(AttendanceConstant.HH_MM_SS));
        recordEntity.setClockStatus(clockStatus);
    }

    private String validatePlace(AttendanceClockDto dto, AttendanceRecordRuleEntity recordRuleEntity, LoginUserDetails loginUserDetails) {
        String electronFenceType = recordRuleEntity.getElectronFenceType();
        String clockPlaceStatus = AttendancePlaceStatus.EX.getDictCode();
        if (StringUtils.isBlank((CharSequence)electronFenceType) || AttendanceElectronFenceType.NONE.getDictCode().equals(electronFenceType)) {
            clockPlaceStatus = AttendancePlaceStatus.OK.getDictCode();
            return clockPlaceStatus;
        }
        if (AttendanceElectronFenceType.OUT_SIGN_OK.getDictCode().equals(electronFenceType)) {
            clockPlaceStatus = AttendancePlaceStatus.OK.getDictCode();
            return clockPlaceStatus;
        }
        List<AttendanceRecordRulePlaceEntity> placeList = this.attendanceRecordRulePlaceRepository.findByRecordRuleId(recordRuleEntity.getId());
        Validate.isTrue((!CollectionUtils.isEmpty(placeList) ? 1 : 0) != 0, (String)"\u4e0d\u5141\u8bb8\u8003\u52e4\u8303\u56f4\u5916\u6253\u5361", (Object[])new Object[0]);
        for (AttendanceRecordRulePlaceEntity placeEntity : placeList) {
            if (Boolean.TRUE.equals(this.validateVisitPlanPlace(dto, loginUserDetails, placeEntity))) {
                clockPlaceStatus = AttendancePlaceStatus.OK.getDictCode();
            }
            if (dto.getClockType().equals(placeEntity.getClockType()) || AttendanceClockType.ON_AND_OFF_WORK.getDictCode().equals(placeEntity.getClockType())) {
                double distance = DistanceUtil.calculatePointDistance((double)dto.getClockLatitude().doubleValue(), (double)dto.getClockLongitude().doubleValue(), (double)placeEntity.getPlaceLatitude().doubleValue(), (double)placeEntity.getPlaceLongitude().doubleValue());
                if (BigDecimal.valueOf(placeEntity.getPlaceRange().intValue()).compareTo(BigDecimal.valueOf(distance)) >= 0) {
                    clockPlaceStatus = AttendancePlaceStatus.OK.getDictCode();
                }
            }
            if (!AttendancePlaceStatus.OK.getDictCode().equals(clockPlaceStatus)) continue;
            break;
        }
        return clockPlaceStatus;
    }

    private Boolean validateVisitPlanPlace(AttendanceClockDto dto, LoginUserDetails loginUserDetails, AttendanceRecordRulePlaceEntity placeEntity) {
        List<Pair<BigDecimal, BigDecimal>> terminalLatLonList;
        if (!"\u540c\u6b65\u62dc\u8bbf\u8ba1\u5212".equals(placeEntity.getPlaceName())) {
            return Boolean.FALSE;
        }
        VisitPlanDetailQueryDto queryDto = new VisitPlanDetailQueryDto();
        queryDto.setVisitUserName(loginUserDetails.getUsername());
        queryDto.setVisitPostCode(loginUserDetails.getPostCode());
        queryDto.setVisitDate(new Date());
        List planDetailVos = this.visitPlanDetailVoService.findByConditions(queryDto);
        if (CollectionUtils.isEmpty((Collection)planDetailVos)) {
            return Boolean.FALSE;
        }
        ArrayList latLonList = Lists.newArrayList();
        List<Pair<BigDecimal, BigDecimal>> customerLatLonList = this.buildCustomerLatLon(planDetailVos);
        if (!CollectionUtils.isEmpty(customerLatLonList)) {
            latLonList.addAll(customerLatLonList);
        }
        if (!CollectionUtils.isEmpty(terminalLatLonList = this.buildTerminalLatLon(planDetailVos))) {
            latLonList.addAll(terminalLatLonList);
        }
        if (CollectionUtils.isEmpty((Collection)latLonList)) {
            return Boolean.FALSE;
        }
        Boolean result = Boolean.FALSE;
        for (Pair latLonPair : latLonList) {
            double distance = DistanceUtil.calculatePointDistance((double)dto.getClockLatitude().doubleValue(), (double)dto.getClockLongitude().doubleValue(), (double)((BigDecimal)latLonPair.getLeft()).doubleValue(), (double)((BigDecimal)latLonPair.getRight()).doubleValue());
            if (BigDecimal.valueOf(placeEntity.getPlaceRange().intValue()).compareTo(BigDecimal.valueOf(distance)) < 0) continue;
            result = Boolean.TRUE;
        }
        return result;
    }

    private List<Pair<BigDecimal, BigDecimal>> buildCustomerLatLon(List<VisitPlanDetailVo> planDetailVos) {
        ArrayList latLonList = Lists.newArrayList();
        List customerCodes = planDetailVos.stream().filter(visitPlanDetailVo -> ClientTypeEnum.DEALER.getDictCode().equals(visitPlanDetailVo.getClientType())).map(VisitPlanDetailVo::getClientCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customerCodes)) {
            List customerVoList = this.customerVoService.findByCustomerCodes(customerCodes);
            List<Object> customerLatLonList = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)customerVoList)) {
                customerLatLonList = customerVoList.stream().filter(customerVo -> Objects.nonNull(customerVo.getLatitude()) && Objects.nonNull(customerVo.getLongitude())).map(customerVo -> Pair.of((Object)customerVo.getLatitude(), (Object)customerVo.getLongitude())).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty((Collection)customerLatLonList)) {
                latLonList.addAll(customerLatLonList);
            }
        }
        return latLonList;
    }

    private List<Pair<BigDecimal, BigDecimal>> buildTerminalLatLon(List<VisitPlanDetailVo> planDetailVos) {
        ArrayList latLonList = Lists.newArrayList();
        List terminalCodes = planDetailVos.stream().filter(visitPlanDetailVo -> ClientTypeEnum.TERMINAL.getDictCode().equals(visitPlanDetailVo.getClientType())).map(VisitPlanDetailVo::getClientCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(terminalCodes)) {
            List terminalVoList = this.terminalVoService.findDetailsByIdsOrTerminalCodes((List)Lists.newLinkedList(), terminalCodes);
            List<Object> terminalLatLonList = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)terminalVoList)) {
                terminalLatLonList = terminalVoList.stream().filter(terminalVo -> Objects.nonNull(terminalVo.getLatitude()) && Objects.nonNull(terminalVo.getLongitude())).map(customerVo -> Pair.of((Object)customerVo.getLatitude(), (Object)customerVo.getLongitude())).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty((Collection)terminalLatLonList)) {
                latLonList.addAll(terminalLatLonList);
            }
        }
        return latLonList;
    }

    private void validateRecord(AttendanceClockDto dto, AttendanceRecordEntity recordEntity, AttendanceRecordRuleEntity recordRuleEntity) {
        String ruleClockStartTime = recordEntity.getRuleClockStartTime();
        String ruleClockEndTime = recordEntity.getRuleClockEndTime();
        String nowTime = LocalTime.now().format(AttendanceConstant.HH_MM_SS);
        Validate.isTrue((ruleClockStartTime.compareTo(nowTime) <= 0 && ruleClockEndTime.compareTo(nowTime) >= 0 ? 1 : 0) != 0, (String)String.format("\u5f53\u524d\u65f6\u95f4\u4e0d\u80fd%s", AttendanceClockType.getByDictCode((String)dto.getClockType()).getValue()), (Object[])new Object[0]);
        if (AttendanceClockType.OFF_WORK.getDictCode().equals(recordEntity.getClockType()) && AttendanceOffWorkClockType.GOTO_WORK_REQUIRED.getDictCode().equals(recordRuleEntity.getOffWorkClockType())) {
            List<AttendanceRecordEntity> recordEntities = this.attendanceRecordRepository.findByUserNameAndRuleTimeId(TenantUtils.getTenantCode(), recordEntity.getUserName(), recordEntity.getRuleTimeId());
            Validate.isTrue((!CollectionUtils.isEmpty(recordEntities = recordEntities.stream().filter(entity -> AttendanceClockType.ON_WORK.getDictCode().equals(entity.getClockType())).collect(Collectors.toList())) ? 1 : 0) != 0, (String)"\u4e0a\u73ed\u6253\u5361\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Validate.isTrue((!AttendanceClockStatus.NONE.getDictCode().equals(recordEntities.get(0).getClockStatus()) ? 1 : 0) != 0, (String)"\u672a\u4e0a\u73ed\u6253\u5361\uff0c\u4e0d\u80fd\u4e0b\u73ed\u6253\u5361\uff01", (Object[])new Object[0]);
        }
        if (BooleanEnum.TRUE.getCapital().equals(recordRuleEntity.getClockPhotograph())) {
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getPictureList()) ? 1 : 0) != 0, (String)"\u8003\u52e4\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private AttendanceRecordVo buildAttendanceRecordVo(AttendanceRecordEntity entity) {
        AttendanceRecordVo attendanceRecordVo = (AttendanceRecordVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, AttendanceRecordVo.class, HashSet.class, ArrayList.class, new String[0]);
        AttendanceRecordRuleEntity recordRuleEntity = (AttendanceRecordRuleEntity)((Object)this.attendanceRecordRuleRepository.getById((Serializable)((Object)entity.getRecordRuleId())));
        if (Objects.isNull((Object)recordRuleEntity)) {
            attendanceRecordVo.setClockTimeStatus(AttendanceClockTimeStatus.TODAY_NOT_NEED_CLOCK.getDictCode());
            return attendanceRecordVo;
        }
        String ruleClockStartTime = entity.getRuleClockStartTime();
        String ruleClockEndTime = entity.getRuleClockEndTime();
        String nowTime = LocalTime.now().format(AttendanceConstant.HH_MM_SS);
        attendanceRecordVo.setClockTimeStatus(AttendanceClockTimeStatus.CURRENT_CAN_CLOCK.getDictCode());
        attendanceRecordVo.setClockPhotograph(recordRuleEntity.getClockPhotograph());
        Pair<Boolean, Boolean> noWorkAbideFlagPair = this.buildNoWorkAbideFlag(recordRuleEntity, entity);
        if (BooleanEnum.FALSE.getCapital().equals(recordRuleEntity.getSignMust()) && Boolean.FALSE.equals(noWorkAbideFlagPair.getLeft())) {
            attendanceRecordVo.setClockTimeStatus(AttendanceClockTimeStatus.CURRENT_CAN_CLOCK.getDictCode());
        } else if (ruleClockStartTime.compareTo(nowTime) > 0 || ruleClockEndTime.compareTo(nowTime) < 0) {
            attendanceRecordVo.setClockTimeStatus(AttendanceClockTimeStatus.NOT_CLOCK_TIME.getDictCode());
        }
        String executeAsWorkingDay = BooleanEnum.FALSE.getCapital();
        if (BooleanEnum.TRUE.getCapital().equals(recordRuleEntity.getSignMust()) && !AttendanceSignOrNonType.SPECIAL_DAY_NO_SIGN.getDictCode().equals(recordRuleEntity.getSignOrNonType())) {
            executeAsWorkingDay = BooleanEnum.TRUE.getCapital();
        }
        if (BooleanEnum.FALSE.getCapital().equals(recordRuleEntity.getSignMust()) && Boolean.TRUE.equals(noWorkAbideFlagPair.getRight())) {
            executeAsWorkingDay = BooleanEnum.TRUE.getCapital();
        }
        attendanceRecordVo.setExecuteAsWorkingDay(executeAsWorkingDay);
        return attendanceRecordVo;
    }

    private Pair<Boolean, Boolean> buildNoWorkAbideFlag(AttendanceRecordRuleEntity recordRuleEntity, AttendanceRecordEntity recordEntity) {
        Boolean haveNoWorkAbide = Boolean.FALSE;
        Boolean currentHaveAbideData = Boolean.FALSE;
        List recordRuleNoWorkAbideList = StringUtils.isNotBlank((CharSequence)recordRuleEntity.getNoWorkAbideInfo()) ? JSON.parseArray((String)recordRuleEntity.getNoWorkAbideInfo(), AttendanceRuleNoWorkAbideVo.class) : null;
        Map<Object, Object> recordRuleHaveNoWorkAbideMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)recordRuleNoWorkAbideList)) {
            recordRuleHaveNoWorkAbideMap = recordRuleNoWorkAbideList.stream().filter(noWorkAbideVo -> BooleanEnum.TRUE.getCapital().equals(noWorkAbideVo.getAbideFlag())).collect(Collectors.toMap(AttendanceRuleNoWorkAbideVo::getKey, t -> t, (a, b) -> b));
            haveNoWorkAbide = !recordRuleHaveNoWorkAbideMap.isEmpty();
        }
        if (Boolean.TRUE.equals(haveNoWorkAbide) && !CollectionUtils.isEmpty(this.listeners)) {
            ArrayList noWorkAbideDataList = Lists.newArrayList();
            RuleNoWorkAbideDataDto dataDto = new RuleNoWorkAbideDataDto();
            dataDto.setRuleCodes((Set)Sets.newHashSet((Object[])new String[]{recordEntity.getRuleCode()}));
            dataDto.setRuleDate(recordEntity.getRuleDate());
            dataDto.setUserName(recordEntity.getUserName());
            this.listeners.forEach(listener -> {
                List list = listener.onRequestByRuleNoWorkAbideDataDto(dataDto);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    noWorkAbideDataList.addAll(list);
                }
            });
            for (AttendanceRuleNoWorkAbideDataVo abideDataVo : noWorkAbideDataList) {
                if (!BooleanEnum.TRUE.getCapital().equals(abideDataVo.getCurrentHaveAbideData()) || !Objects.nonNull(recordRuleHaveNoWorkAbideMap.get(abideDataVo.getKey()))) continue;
                currentHaveAbideData = Boolean.TRUE;
                break;
            }
        }
        return Pair.of((Object)haveNoWorkAbide, (Object)currentHaveAbideData);
    }
}

