/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRulePlaceEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRulePlaceRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRulePlaceService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceElectronFenceType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceRulePlaceService")
public class AttendanceRulePlaceServiceImpl
implements AttendanceRulePlaceService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceRulePlaceServiceImpl.class);
    @Autowired
    private AttendanceRulePlaceRepository attendanceRulePlaceRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(AttendanceRuleDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u8003\u52e4\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.attendanceRulePlaceRepository.deleteByRuleId(dto.getId());
        if (CollectionUtils.isEmpty((Collection)dto.getPlaceList())) {
            return;
        }
        this.updateValidation(dto);
        List entities = dto.getPlaceList().stream().map(placeDto -> {
            AttendanceRulePlaceEntity entity = (AttendanceRulePlaceEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(placeDto, AttendanceRulePlaceEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setRuleId(dto.getId());
            return entity;
        }).collect(Collectors.toList());
        this.attendanceRulePlaceRepository.saveBatch(entities);
    }

    private void updateValidation(AttendanceRuleDto dto) {
        HashSet clockTypeSet = Sets.newHashSet();
        Validate.notBlank((CharSequence)dto.getElectronFenceType(), (String)"\u7f3a\u5931\u6253\u5361\u8303\u56f4\u7c7b\u578b", (Object[])new Object[0]);
        dto.getPlaceList().forEach(placeDto -> {
            int placeNo = dto.getPlaceList().indexOf(placeDto) + 1;
            placeDto.setPlaceNo(String.valueOf(placeNo));
            Validate.notBlank((CharSequence)placeDto.getPlaceName(), (String)String.format("\u5e8f\u53f7%s,\u7f3a\u5931\u5730\u70b9\u540d\u79f0", placeNo), (Object[])new Object[0]);
            Validate.isTrue((Objects.nonNull(placeDto.getPlaceRange()) && placeDto.getPlaceRange() > 0 ? 1 : 0) != 0, (String)String.format("\u5e8f\u53f7%s,\u5730\u70b9\u8303\u56f4\u6570\u636e\u9519\u8bef", placeNo), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)placeDto.getClockType(), (String)String.format("\u5e8f\u53f7%s,\u7f3a\u5931\u6253\u5361\u7c7b\u578b", placeNo), (Object[])new Object[0]);
            Validate.notNull((Object)placeDto.getPlaceLatitude(), (String)String.format("\u5e8f\u53f7%s,\u7f3a\u5931\u5730\u70b9\u7eac\u5ea6", placeNo), (Object[])new Object[0]);
            Validate.notNull((Object)placeDto.getPlaceLongitude(), (String)String.format("\u5e8f\u53f7%s,\u7f3a\u5931\u5730\u70b9\u7ecf\u5ea6", placeNo), (Object[])new Object[0]);
            clockTypeSet.add(placeDto.getClockType());
        });
        if (!AttendanceElectronFenceType.NONE.getDictCode().equals(dto.getElectronFenceType())) {
            Validate.isTrue((clockTypeSet.contains(AttendanceClockType.ON_AND_OFF_WORK.getDictCode()) || clockTypeSet.contains(AttendanceClockType.OFF_WORK.getDictCode()) && clockTypeSet.contains(AttendanceClockType.ON_WORK.getDictCode()) ? 1 : 0) != 0, (String)"\u6253\u5361\u5730\u70b9\u5fc5\u987b\u5305\u542b\u4e0a\u4e0b\u73ed\u6253\u5361", (Object[])new Object[0]);
        }
    }
}

