/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleSpecialDateEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRuleSpecialDateRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRuleSpecialDateService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceSpecialDateType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceRuleSpecialDateService")
public class AttendanceRuleSpecialDateServiceImpl
implements AttendanceRuleSpecialDateService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceRuleSpecialDateServiceImpl.class);
    @Autowired
    private AttendanceRuleSpecialDateRepository attendanceRuleSpecialDateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(AttendanceRuleDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u8003\u52e4\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.attendanceRuleSpecialDateRepository.deleteByRuleId(dto.getId());
        if (CollectionUtils.isEmpty((Collection)dto.getSpecialDateList())) {
            return;
        }
        this.updateValidation(dto);
        List entities = dto.getSpecialDateList().stream().map(specialDateDto -> {
            AttendanceRuleSpecialDateEntity entity = (AttendanceRuleSpecialDateEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(specialDateDto, AttendanceRuleSpecialDateEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setRuleId(dto.getId());
            return entity;
        }).collect(Collectors.toList());
        this.attendanceRuleSpecialDateRepository.saveBatch(entities);
    }

    private void updateValidation(AttendanceRuleDto dto) {
        ArrayList mustClockDates = Lists.newArrayList();
        ArrayList notClockDates = Lists.newArrayList();
        dto.getSpecialDateList().forEach(specialDateDto -> {
            Validate.notBlank((CharSequence)specialDateDto.getSpecialDate(), (String)"\u7f3a\u5931\u7279\u6b8a\u65e5\u671f", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)specialDateDto.getSpecialDateType(), (String)"\u7f3a\u5931\u7279\u6b8a\u65e5\u671f\u7c7b\u578b", (Object[])new Object[0]);
            Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)specialDateDto.getSpecialDate()), (String)"\u975e\u6cd5\u7684\u7279\u6b8a\u65e5\u671f\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
            if (AttendanceSpecialDateType.MUST_CLOCK.getDictCode().equals(specialDateDto.getSpecialDateType())) {
                mustClockDates.add(specialDateDto.getSpecialDate());
            }
            if (AttendanceSpecialDateType.NOT_CLOCK.getDictCode().equals(specialDateDto.getSpecialDateType())) {
                notClockDates.add(specialDateDto.getSpecialDate());
            }
        });
        mustClockDates.retainAll(notClockDates);
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)mustClockDates), (String)"\u5fc5\u6253\u5361\u65e5\u671f\u548c\u4e0d\u5fc5\u6253\u5361\u65e5\u671f\u91cd\u590d", (Object[])new Object[0]);
    }
}

