/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleTimeEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRuleTimeRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRuleTimeService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleTimeDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceRuleTimeService")
public class AttendanceRuleTimeServiceImpl
implements AttendanceRuleTimeService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceRuleTimeServiceImpl.class);
    @Autowired
    private AttendanceRuleTimeRepository attendanceRuleTimeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(AttendanceRuleDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u8003\u52e4\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.attendanceRuleTimeRepository.deleteByRuleId(dto.getId());
        this.updateValidation(dto);
        List entities = dto.getTimeList().stream().map(timeDto -> {
            AttendanceRuleTimeEntity entity = (AttendanceRuleTimeEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(timeDto, AttendanceRuleTimeEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setRuleId(dto.getId());
            return entity;
        }).collect(Collectors.toList());
        this.attendanceRuleTimeRepository.saveBatch(entities);
    }

    private void updateValidation(AttendanceRuleDto dto) {
        if (AttendanceRuleType.STATIC.getDictCode().equals(dto.getRuleType())) {
            String indexOffWorkTime;
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getTimeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8003\u52e4\u65f6\u95f4", (Object[])new Object[0]);
            String indexOffWorkClockEndTime = indexOffWorkTime = "00:00:00";
            String indexOnWorkClockEndTime = indexOffWorkTime;
            for (AttendanceRuleTimeDto timeDto : dto.getTimeList()) {
                int timeNo = dto.getTimeList().indexOf(timeDto) + 1;
                timeDto.setTimeNo(String.valueOf(timeNo));
                Validate.notBlank((CharSequence)timeDto.getOnWorkTime(), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u7f3a\u5931\u4e0a\u73ed\u65f6\u95f4", timeNo), (Object[])new Object[0]);
                Validate.notBlank((CharSequence)timeDto.getOffWorkTime(), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u7f3a\u5931\u4e0b\u73ed\u65f6\u95f4", timeNo), (Object[])new Object[0]);
                Validate.notBlank((CharSequence)timeDto.getOffWorkClockEndTime(), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u7f3a\u5931\u4e0b\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4", timeNo), (Object[])new Object[0]);
                Validate.notBlank((CharSequence)timeDto.getOffWorkClockStartTime(), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u7f3a\u5931\u4e0b\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4", timeNo), (Object[])new Object[0]);
                Validate.notBlank((CharSequence)timeDto.getOnWorkClockEndTime(), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u7f3a\u5931\u4e0a\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4", timeNo), (Object[])new Object[0]);
                Validate.notBlank((CharSequence)timeDto.getOnWorkClockStartTime(), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u7f3a\u5931\u4e0a\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4", timeNo), (Object[])new Object[0]);
                Validate.isTrue((boolean)DateTimeValidateUtil.validateTime((String)timeDto.getOnWorkTime()), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u975e\u6cd5\u7684\u4e0a\u73ed\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm:ss]", timeNo), (Object[])new Object[0]);
                Validate.isTrue((boolean)DateTimeValidateUtil.validateTime((String)timeDto.getOffWorkTime()), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u975e\u6cd5\u7684\u4e0b\u73ed\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm:ss]", timeNo), (Object[])new Object[0]);
                Validate.isTrue((boolean)DateTimeValidateUtil.validateTime((String)timeDto.getOffWorkClockEndTime()), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u975e\u6cd5\u7684\u4e0b\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm:ss]", timeNo), (Object[])new Object[0]);
                Validate.isTrue((boolean)DateTimeValidateUtil.validateTime((String)timeDto.getOffWorkClockStartTime()), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u975e\u6cd5\u7684\u4e0b\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm:ss]", timeNo), (Object[])new Object[0]);
                Validate.isTrue((boolean)DateTimeValidateUtil.validateTime((String)timeDto.getOnWorkClockEndTime()), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u975e\u6cd5\u7684\u4e0a\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm:ss]", timeNo), (Object[])new Object[0]);
                Validate.isTrue((boolean)DateTimeValidateUtil.validateTime((String)timeDto.getOnWorkClockStartTime()), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u975e\u6cd5\u7684\u4e0a\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm:ss]", timeNo), (Object[])new Object[0]);
                Validate.isTrue((timeDto.getOffWorkClockStartTime().compareTo(timeDto.getOffWorkClockEndTime()) < 0 ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u4e0b\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u4e0b\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4", timeNo), (Object[])new Object[0]);
                Validate.isTrue((timeDto.getOnWorkClockStartTime().compareTo(timeDto.getOnWorkClockEndTime()) < 0 ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u4e0a\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u4e0a\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4", timeNo), (Object[])new Object[0]);
                Validate.isTrue((timeDto.getOffWorkClockStartTime().compareTo(timeDto.getOnWorkClockEndTime()) >= 0 ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65f6\u95f4,\u4e0b\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u4e0a\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4", timeNo), (Object[])new Object[0]);
                Validate.isTrue((indexOffWorkTime.compareTo(timeDto.getOnWorkTime()) <= 0 ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u6bb5\u4e0a\u73ed\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7b2c%s\u6bb5\u4e0b\u73ed\u65f6\u95f4", timeNo, timeNo - 1), (Object[])new Object[0]);
                Validate.isTrue((indexOnWorkClockEndTime.compareTo(timeDto.getOnWorkClockStartTime()) <= 0 ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u6bb5\u4e0a\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7b2c%s\u6bb5\u4e0a\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4", timeNo, timeNo - 1), (Object[])new Object[0]);
                Validate.isTrue((indexOnWorkClockEndTime.compareTo(timeDto.getOffWorkClockStartTime()) <= 0 ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u6bb5\u4e0b\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7b2c%s\u6bb5\u4e0a\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4", timeNo, timeNo - 1), (Object[])new Object[0]);
                Validate.isTrue((indexOffWorkClockEndTime.compareTo(timeDto.getOnWorkClockStartTime()) <= 0 ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u6bb5\u4e0a\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7b2c%s\u6bb5\u4e0b\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4", timeNo, timeNo - 1), (Object[])new Object[0]);
                Validate.isTrue((indexOffWorkClockEndTime.compareTo(timeDto.getOffWorkClockStartTime()) <= 0 ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u6bb5\u4e0b\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7b2c%s\u6bb5\u4e0b\u73ed\u6253\u5361\u7ed3\u675f\u65f6\u95f4", timeNo, timeNo - 1), (Object[])new Object[0]);
                indexOffWorkTime = timeDto.getOffWorkTime();
                indexOnWorkClockEndTime = timeDto.getOnWorkClockEndTime();
                indexOffWorkClockEndTime = timeDto.getOffWorkClockEndTime();
            }
        } else {
            ArrayList timeList = Lists.newArrayList();
            AttendanceRuleTimeDto timeDto = new AttendanceRuleTimeDto();
            timeDto.setOnWorkTime("00:00:00");
            timeDto.setOffWorkTime("23:59:59");
            timeDto.setOnWorkClockStartTime(timeDto.getOnWorkTime());
            timeDto.setOnWorkClockEndTime(timeDto.getOffWorkTime());
            timeDto.setOffWorkClockStartTime(timeDto.getOnWorkTime());
            timeDto.setOffWorkClockEndTime(timeDto.getOffWorkTime());
            timeDto.setTimeNo("1");
            timeList.add(timeDto);
            dto.setTimeList((List)timeList);
        }
    }
}

