/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.position.level.sdk.service.PositionLevelVoService;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRuleRepository;
import com.biz.crm.sfa.business.attendance.sdk.dto.RuleConditionDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleScopeType;
import com.biz.crm.sfa.business.attendance.sdk.event.AttendanceRuleEventListener;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceRuleVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleScopeVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AttendanceRuleVoServiceImpl
implements AttendanceRuleVoService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceRuleVoServiceImpl.class);
    @Autowired
    private AttendanceRuleRepository attendanceRuleRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private OrgVoService orgVoService;
    @Autowired
    private PositionLevelVoService positionLevelVoService;
    @Autowired(required=false)
    private List<AttendanceRuleEventListener> listeners;

    public AttendanceRuleVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        List<AttendanceRuleEntity> entities = this.attendanceRuleRepository.findByIds(Lists.newArrayList((Object[])new String[]{id}));
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        AttendanceRuleVo attendanceRuleVo = (AttendanceRuleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entities.get(0), AttendanceRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.perfectScopeInfo(Lists.newArrayList((Object[])new AttendanceRuleVo[]{attendanceRuleVo}));
        if (!CollectionUtils.isEmpty(this.listeners)) {
            HashSet ruleCodes = Sets.newHashSet((Object[])new String[]{attendanceRuleVo.getRuleCode()});
            ArrayList noWorkAbideInfoList = Lists.newArrayList();
            this.listeners.forEach(listener -> {
                List abideList = listener.onRequestByRuleCodes(ruleCodes);
                if (!CollectionUtils.isEmpty((Collection)abideList)) {
                    noWorkAbideInfoList.addAll(abideList);
                }
            });
            attendanceRuleVo.setNoWorkAbideInfoList((List)noWorkAbideInfoList);
        }
        return attendanceRuleVo;
    }

    public List<AttendanceRuleVo> findByRuleConditionDto(RuleConditionDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newLinkedList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<AttendanceRuleEntity> entities = this.attendanceRuleRepository.findByRuleConditionDto(dto);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entities, AttendanceRuleEntity.class, AttendanceRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void perfectScopeInfo(List<AttendanceRuleVo> ruleList) {
        if (CollectionUtils.isEmpty(ruleList)) {
            return;
        }
        List<AttendanceRuleScopeVo> scopeList = ruleList.stream().filter(vo -> !CollectionUtils.isEmpty((Collection)vo.getScopeList())).flatMap(vo -> vo.getScopeList().stream()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(scopeList)) {
            return;
        }
        HashSet orgCodes = Sets.newHashSet();
        HashSet positionLevelCodes = Sets.newHashSet();
        scopeList.forEach(scopeVo -> {
            if (AttendanceRuleScopeType.ORG.getDictCode().equals(scopeVo.getScopeType())) {
                orgCodes.add(scopeVo.getScopeCode());
            }
            if (AttendanceRuleScopeType.POSITION_LEVEL.getDictCode().equals(scopeVo.getScopeType())) {
                positionLevelCodes.add(scopeVo.getScopeCode());
            }
        });
        Map<String, OrgVo> orgMap = this.buildOrgMap(orgCodes);
        Map<String, PositionLevelVo> positionLevelMap = this.buildPositionLevelMap(positionLevelCodes);
        for (AttendanceRuleScopeVo scopeVo2 : scopeList) {
            if (AttendanceRuleScopeType.ORG.getDictCode().equals(scopeVo2.getScopeType())) {
                OrgVo orgVo = orgMap.getOrDefault(scopeVo2.getScopeCode(), new OrgVo());
                scopeVo2.setScopeName(orgVo.getOrgName());
            }
            if (!AttendanceRuleScopeType.POSITION_LEVEL.getDictCode().equals(scopeVo2.getScopeType())) continue;
            PositionLevelVo positionLevelVo = positionLevelMap.getOrDefault(scopeVo2.getScopeCode(), new PositionLevelVo());
            scopeVo2.setScopeName(positionLevelVo.getPositionLevelName());
        }
    }

    private Map<String, PositionLevelVo> buildPositionLevelMap(Set<String> positionLevelCodes) {
        List positionLevelList;
        Map<Object, Object> positionLevelMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(positionLevelCodes) && !CollectionUtils.isEmpty((Collection)(positionLevelList = this.positionLevelVoService.findByIdsOrCodes(null, (List)Lists.newArrayList(positionLevelCodes))))) {
            positionLevelMap = positionLevelList.stream().collect(Collectors.toMap(PositionLevelVo::getPositionLevelCode, t -> t, (a, b) -> b));
        }
        return positionLevelMap;
    }

    private Map<String, OrgVo> buildOrgMap(Set<String> orgCodes) {
        List orgList;
        Map<Object, Object> orgMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(orgCodes) && !CollectionUtils.isEmpty((Collection)(orgList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList(orgCodes))))) {
            orgMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, t -> t, (a, b) -> b));
        }
        return orgMap;
    }
}

