package com.biz.crm.sfa.business.attendance.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceClockDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendancePlaceStatusDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.TodayHistoryRecordDto;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceRecordVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRecordVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 考勤记录: AttendanceRecordVo: 考勤记录信息
 *
 * @author ning.zhang
 * @date 2022/5/19
 */
@Slf4j
@RestController
@RequestMapping("/v1/attendance/attendanceRecord")
@Api(tags = "考勤记录: AttendanceRecordVo: 考勤记录信息")
public class AttendanceRecordVoController {

  @Autowired
  private AttendanceRecordVoService attendanceRecordVoService;

  /**
   * 移动端-当前用户考勤打卡
   *
   * @param dto 参数dto
   */
  @ApiOperation(value = "移动端-当前用户考勤打卡")
  @PostMapping("/updateByAttendanceClockDto")
  public Result updateByAttendanceClockDto(@RequestBody AttendanceClockDto dto) {
    try {
      this.attendanceRecordVoService.updateByAttendanceClockDto(dto);
      return Result.ok("打卡成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 移动端-获取当前用户考勤打卡信息
   *
   * @param dto 参数dto
   * @return 考勤打卡信息
   */
  @ApiOperation(value = "移动端-获取当前用户考勤打卡信息")
  @GetMapping("/findByAttendanceClockDto")
  public Result<AttendanceRecordVo> findByAttendanceClockDto(@ApiParam(name = "AttendanceClockDto") AttendanceClockDto dto) {
    try {
      return Result.ok(this.attendanceRecordVoService.findByAttendanceClockDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 移动端-获取当前用户今日历史考勤记录信息
   *
   * @param dto 参数dto
   * @return 考勤记录信息
   */
  @ApiOperation(value = "移动端-获取当前用户今日历史考勤记录信息")
  @GetMapping("/findByTodayHistoryRecordDto")
  public Result<List<AttendanceRecordVo>> findByTodayHistoryRecordDto(@ApiParam(name = "TodayHistoryRecordDto") TodayHistoryRecordDto dto) {
    try {
      return Result.ok(this.attendanceRecordVoService.findByTodayHistoryRecordDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 移动端-查询当前用户考勤地点状态信息
   *
   * @param dto 参数dto
   * @return 考勤地点状态信息
   */
  @ApiOperation(value = "移动端-查询当前用户考勤地点状态信息")
  @GetMapping("/findByAttendancePlaceStatusDto")
  public Result<AttendanceRecordVo> findByAttendancePlaceStatusDto(@ApiParam(name = "AttendancePlaceStatusDto") AttendancePlaceStatusDto dto) {
    try {
      return Result.ok(this.attendanceRecordVoService.findByAttendancePlaceStatusDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过考勤记录ID查询打卡详情
   *
   * @param id 考勤记录ID
   * @return 考勤记录
   */
  @ApiOperation(value = "通过考勤记录ID查询打卡详情")
  @GetMapping("/findById")
  public Result<AttendanceRecordVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      List<AttendanceRecordVo> list = this.attendanceRecordVoService.findByIds(Lists.newArrayList(id));
      return Result.ok(CollectionUtils.isEmpty(list) ? null : list.get(0));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
