package com.biz.crm.sfa.business.attendance.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleEntity;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRuleService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleExecuteDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRulePageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 考勤规则: AttendanceRule: 考勤规则配置
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@Slf4j
@RestController
@RequestMapping("/v1/attendance/attendanceRule")
@Api(tags = "考勤规则: AttendanceRule: 考勤规则配置")
public class AttendanceRuleController {

  @Autowired
  private AttendanceRuleService attendanceRuleService;

  /**
   * 新增考勤规则信息
   *
   * @param dto 参数dto
   * @return 新增考勤规则数据
   */
  @ApiOperation(value = "新增考勤规则")
  @PostMapping("")
  public Result<AttendanceRuleEntity> create(@RequestBody AttendanceRuleDto dto) {
    try {
      return Result.ok(this.attendanceRuleService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新考勤规则信息
   *
   * @param dto 参数dto
   * @return 更新后考勤规则数据
   */
  @ApiOperation(value = "更新考勤规则信息")
  @PatchMapping("")
  public Result<AttendanceRuleEntity> update(@RequestBody AttendanceRuleDto dto) {
    try {
      return Result.ok(this.attendanceRuleService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除考勤规则
   *
   * @param ids 考勤规则id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.attendanceRuleService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用考勤规则
   *
   * @param ids 考勤规则id集合
   * @return 操作结果
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enableBatch")
  public Result enableBatch(@RequestBody List<String> ids) {
    try {
      this.attendanceRuleService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用考勤规则
   *
   * @param ids 考勤规则id集合
   * @return 操作结果
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disableBatch")
  public Result disableBatch(@RequestBody List<String> ids) {
    try {
      this.attendanceRuleService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 考勤规则分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 考勤规则分页数据
   */
  @ApiOperation(value = "考勤规则分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<AttendanceRuleEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "AttendanceRuleCustomerPageDto", value = "分页Dto") AttendanceRulePageDto dto) {
    try {
      return Result.ok(this.attendanceRuleService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 执行考勤规则
   *
   * @param dto 请求参数dto
   */
  @ApiOperation(value = "执行考勤规则")
  @PatchMapping("/execute")
  public Result execute(@RequestBody AttendanceRuleExecuteDto dto) {
    try {
      this.attendanceRuleService.execute(dto);
      return Result.ok("执行成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
