package com.biz.crm.sfa.business.attendance.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceRuleVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 考勤规则: AttendanceRuleVo: 考勤规则配置
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@Slf4j
@RestController
@RequestMapping("/v1/attendance/attendanceRule")
@Api(tags = "考勤规则: AttendanceRuleVo: 考勤规则配置")
public class AttendanceRuleVoController {

  @Autowired
  private AttendanceRuleVoService attendanceRuleVoService;

  /**
   * 通过ID获取考勤规则详细信息
   *
   * @param id 考勤规则ID
   * @return 考勤规则信息
   */
  @ApiOperation(value = "通过ID获取考勤规则详细信息")
  @GetMapping("/findById")
  public Result<AttendanceRuleVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.attendanceRuleVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
