package com.biz.crm.sfa.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 考勤记录实体类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceRecordEntity", description = "考勤记录实体类")
@Entity
@TableName("sfa_attendance_record")
@Table(name = "sfa_attendance_record", indexes = {
    @Index(name = "sfa_attendance_record_index1", columnList = "record_rule_id"),
    @Index(name = "sfa_attendance_record_index2", columnList = "user_name"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_attendance_record", comment = "考勤记录表")
public class AttendanceRecordEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 3460601362198321611L;


  /**
   * 考勤记录规则ID
   */
  @ApiModelProperty("考勤记录规则ID")
  @Column(name = "record_rule_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '考勤记录规则ID'")
  private String recordRuleId;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  @Column(name = "rule_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '规则ID'")
  private String ruleId;

  /**
   * 规则编码
   */
  @ApiModelProperty("规则编码")
  @Column(name = "rule_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '规则编码'")
  private String ruleCode;

  /**
   * 打卡类型(on_work:上班打卡,off_work:下班打卡)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType
   */
  @ApiModelProperty("打卡类型(on_work:上班打卡,off_work:下班打卡)")
  @Column(name = "clock_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '打卡类型(on_work:上班打卡,off_work:下班打卡)'")
  private String clockType;

  /**
   * 是否已经使用(Y:已经打卡;N:未处理)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否已经使用(Y:已经打卡;N:未处理)")
  @Column(name = "used_status", length = 4, nullable = false, columnDefinition = "VARCHAR(4) NOT NULL COMMENT '是否已经使用(Y:已经打卡;N:未处理)'")
  private String usedStatus;

  /**
   * 考勤日期(yyyy-MM-dd)
   */
  @ApiModelProperty("考勤日期(yyyy-MM-dd)")
  @Column(name = "rule_date", columnDefinition = "VARCHAR(10) COMMENT '考勤日期(yyyy-MM-dd)'")
  private String ruleDate;

  /**
   * 打卡时间(HH:mm:ss)
   */
  @ApiModelProperty("打卡时间(HH:mm:ss)")
  @Column(name = "clock_time", length = 10, columnDefinition = "VARCHAR(10) COMMENT '考勤签到时间(HH:mm:ss)'")
  private String clockTime;

  /**
   * 考勤时间规则ID
   */
  @ApiModelProperty("考勤规则时间ID")
  @Column(name = "rule_time_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '考勤规则时间ID'")
  private String ruleTimeId;

  /**
   * 考勤时间规则-打卡时间(HH:mm:ss)
   */
  @ApiModelProperty("考勤时间规则-打卡时间(HH:mm:ss)")
  @Column(name = "rule_clock_time", length = 10, columnDefinition = "VARCHAR(10) COMMENT '考勤时间规则-打卡时间(HH:mm:ss)'")
  private String ruleClockTime;

  /**
   * 考勤时间规则-打卡开始时间(HH:mm:ss)
   */
  @ApiModelProperty("考勤时间规则-打卡开始时间(HH:mm:ss)")
  @Column(name = "rule_clock_start_time", length = 10, columnDefinition = "VARCHAR(10) COMMENT '考勤时间规则-打卡开始时间(HH:mm:ss)'")
  private String ruleClockStartTime;

  /**
   * 考勤时间规则-打卡结束时间(HH:mm:ss)
   */
  @ApiModelProperty("考勤时间规则-打卡结束时间(HH:mm:ss)")
  @Column(name = "rule_clock_end_time", length = 10, columnDefinition = "VARCHAR(10) COMMENT '考勤时间规则-打卡结束时间(HH:mm:ss)'")
  private String ruleClockEndTime;

  /**
   * 打卡地点
   */
  @ApiModelProperty("打卡地点")
  @Column(name = "clock_place", length = 500, columnDefinition = "VARCHAR(500) COMMENT '打卡地点'")
  private String clockPlace;

  /**
   * 打卡地点经度
   */
  @ApiModelProperty("打卡地点经度")
  @Column(name = "clock_longitude", columnDefinition = "decimal(12,8) COMMENT '打卡地点经度'")
  private BigDecimal clockLongitude;

  /**
   * 打卡地点地点纬度
   */
  @ApiModelProperty("打卡地点地点纬度")
  @Column(name = "clock_latitude", columnDefinition = "decimal(12,8) COMMENT '打卡地点地点纬度'")
  private BigDecimal clockLatitude;

  /**
   * 打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus
   */
  @ApiModelProperty("打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退)")
  @Column(name = "clock_status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '打卡状态(none:未打卡;ok:正常;be_late:迟到;leave_early:早退)'")
  private String clockStatus;

  /**
   * 打卡地点状态(ok:正常;ex:异常)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendancePlaceStatus
   */
  @ApiModelProperty("打卡地点状态(ok:正常;ex:异常)")
  @Column(name = "clock_place_status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '考勤地点状态(ok:正常;ex:异常)'")
  private String clockPlaceStatus;

  /**
   * 打卡人员账号
   */
  @ApiModelProperty("打卡人员账号")
  @Column(name = "user_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '打卡人员账号'")
  private String userName;

  /**
   * 打卡人员账号
   */
  @ApiModelProperty("打卡人员姓名")
  @Column(name = "user_real_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '打卡人员姓名'")
  private String userRealName;

  /**
   * 异常备注
   */
  @ApiModelProperty("异常备注")
  @Column(name = "exception_remarks", length = 2000, columnDefinition = "VARCHAR(2000) COMMENT '异常备注'")
  private String exceptionRemarks;

  /**
   * 职位编码
   */
  @Column(name = "post_code", columnDefinition = "VARCHAR(64) COMMENT '职位编码'")
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @Column(name = "post_name", columnDefinition = "VARCHAR(64) COMMENT '职位名称'")
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 组织编码
   */
  @Column(name = "org_code", columnDefinition = "VARCHAR(64)  COMMENT '组织编码'")
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @Column(name = "org_name", columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 考勤照片
   */
  @ApiModelProperty("考勤照片")
  @Transient
  @TableField(exist = false)
  private List<AttendanceRecordPictureEntity> pictureList;
}
