package com.biz.crm.sfa.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 考勤记录照片实体类
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceRecordPictureEntity", description = "考勤记录照片实体类")
@Entity
@TableName("sfa_attendance_record_picture")
@Table(name = "sfa_attendance_record_picture", indexes = {
    @Index(name = "sfa_attendance_record_index1", columnList = "record_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_attendance_record_picture", comment = "考勤记录照片表")
public class AttendanceRecordPictureEntity extends FileEntity {

  private static final long serialVersionUID = 3460601362198321611L;

  /**
   * 考勤记录ID
   */
  @ApiModelProperty("考勤记录ID")
  @Column(name = "record_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '考勤记录ID'")
  private String recordId;
}
