package com.biz.crm.sfa.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 考勤规则实体类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceRuleEntity", description = "考勤规则实体类")
@Entity
@TableName("sfa_attendance_rule")
@Table(name = "sfa_attendance_rule", indexes = {
    @Index(name = "sfa_attendance_rule_index1", columnList = "rule_code", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_attendance_rule", comment = "考勤规则表")
public class AttendanceRuleEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 2800305556748386854L;

  /**
   * 规则编码
   */
  @ApiModelProperty("规则编码")
  @Column(name = "rule_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '规则编码'")
  private String ruleCode;

  /**
   * 规则名称
   */
  @ApiModelProperty("规则名称")
  @Column(name = "rule_name", length = 100, nullable = false, columnDefinition = "VARCHAR(100) NOT NULL COMMENT '规则名称'")
  private String ruleName;

  /**
   * 规则类型(static:固定时间上下班规则;free_time:自由时间上下班规则)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleType
   */
  @ApiModelProperty("规则类型(static:固定时间上下班规则;free_time:自由时间上下班规则)")
  @Column(name = "rule_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '规则类型(static:固定时间上下班规则;free_time:自由时间上下班规则)'")
  private String ruleType;

  /**
   * 打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceElectronFenceType
   */
  @ApiModelProperty("打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)")
  @Column(name = "electron_fence_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)'")
  private String electronFenceType;

  /**
   * 工作日(1:星期一;2:星期二;3:星期三;4:星期四;5:星期五;6:星期六;7:星期日)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceWorkingDayType
   */
  @ApiModelProperty("工作日(1:星期一;2:星期二;3:星期三;4:星期四;5:星期五;6:星期六;7:星期日)")
  @Column(name = "working_day", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '工作日(1:星期一;2:星期二;3:星期三;4:星期四;5:星期五;6:星期六;7:星期日)'")
  private String workingDay;

  /**
   * 是否同步节假日-节假日期间不用打卡(Y:同步;N:不同步)
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否同步节假日-节假日期间不用打卡(Y:同步;N:不同步)")
  @Column(name = "sync_holiday", length = 4, nullable = false, columnDefinition = "VARCHAR(4) NOT NULL COMMENT '是否同步节假日-节假日期间不用打卡(Y:同步;N:不同步)'")
  private String syncHoliday;

  /**
   * 打卡是否需要拍照(Y:需要;N:不需要)
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("打卡是否需要拍照(Y:需要;N:不需要)")
  @Column(name = "clock_photograph", length = 4, nullable = false, columnDefinition = "VARCHAR(4) NOT NULL COMMENT '打卡是否需要拍照(Y:需要;N:不需要)'")
  private String clockPhotograph;

  /**
   * 下班打卡类型(no_sign:下班不需要打卡;goto_work_required:下班需要打卡，且必须打上班卡才能打下班卡;goto_work_no_required:下班需要打卡，无需打上班卡，就能打下班卡)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceOffWorkClockType
   */
  @ApiModelProperty("下班打卡类型(no_sign:下班不需要打卡;goto_work_required:下班需要打卡，且必须打上班卡才能打下班卡;goto_work_no_required:下班需要打卡，无需打上班卡，就能打下班卡)")
  @Column(name = "off_work_clock_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '下班打卡类型(no_sign:下班不需要打卡;goto_work_required:下班需要打卡，且必须打上班卡才能打下班卡;goto_work_no_required:下班需要打卡，无需打上班卡，就能打下班卡)'")
  private String offWorkClockType;

  /**
   * 规则生效类型(now:立即生效;tomorrow:明日生效)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleEffectiveType
   */
  @ApiModelProperty("规则生效类型(now:立即生效;tomorrow:明日生效)")
  @Column(name = "rule_effective", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '规则生效类型(now:立即生效;tomorrow:明日生效)'")
  private String ruleEffective;

  /**
   * 考勤地点信息
   */
  @ApiModelProperty("考勤地点信息")
  @Transient
  @TableField(exist = false)
  private List<AttendanceRulePlaceEntity> placeList;

  /**
   * 考勤范围信息
   */
  @ApiModelProperty("考勤范围信息")
  @Transient
  @TableField(exist = false)
  private List<AttendanceRuleScopeEntity> scopeList;

  /**
   * 考勤时间信息
   */
  @ApiModelProperty("考勤时间信息")
  @Transient
  @TableField(exist = false)
  private List<AttendanceRuleTimeEntity> timeList;

  /**
   * 考勤特殊日期信息
   */
  @ApiModelProperty("考勤特殊日期信息")
  @Transient
  @TableField(exist = false)
  private List<AttendanceRuleSpecialDateEntity> specialDateList;
}
