package com.biz.crm.sfa.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 考勤规则特殊日期实体类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceRuleSpecialDateEntity", description = "考勤规则特殊日期实体类")
@Entity
@TableName("sfa_attendance_rule_special_date")
@Table(name = "sfa_attendance_rule_special_date", indexes = {
    @Index(name = "sfa_attendance_rule_special_date_index1", columnList = "rule_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_attendance_rule_special_date", comment = "考勤规则特殊日期表")
public class AttendanceRuleSpecialDateEntity extends UuidOpEntity {

  private static final long serialVersionUID = -3786600586788141607L;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  @Column(name = "rule_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '规则ID'")
  private String ruleId;

  /**
   * 特殊日期类型 (must_clock:必须打卡日期;not_clock:不用打卡日期)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceSpecialDateType
   */
  @ApiModelProperty("特殊日期类型 (must_clock:必须打卡日期;not_clock:不用打卡日期)")
  @Column(name = "special_date_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '特殊日期类型 (must_clock:必须打卡日期;not_clock:不用打卡日期)'")
  private String specialDateType;

  /**
   * 特殊日期
   */
  @ApiModelProperty("特殊日期")
  @Column(name = "special_date", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '特殊日期'")
  private String specialDate;

}
