package com.biz.crm.sfa.business.attendance.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyEntity;
import com.biz.crm.sfa.business.attendance.local.model.FillApplyConditionModel;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 补打考勤申请表的mybatis-plus接口类 {@link AttendanceFillApplyEntity}
 *
 * @author ning.zhang
 * @date 2022-05-25 10:40:07
 */
public interface AttendanceFillApplyMapper extends BaseMapper<AttendanceFillApplyEntity> {

  /**
   * 多条件查询考勤补打卡申请列表
   *
   * @param model 条件model
   * @return 考勤补打卡申请列表
   */
  List<AttendanceFillApplyEntity> findByFillApplyConditionModel(@Param("model") FillApplyConditionModel model);

  /**
   * 通过ID集合查询补打卡申请信息
   *
   * @param ids ID集合
   * @return 补打卡申请信息
   */
  List<AttendanceFillApplyEntity> findByIds(@Param("ids") List<String> ids);
}

