package com.biz.crm.sfa.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordPictureEntity;
import com.biz.crm.sfa.business.attendance.local.mapper.AttendanceRecordPictureMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 考勤记录照片表的数据库访问类 {@link AttendanceRecordPictureEntity}
 *
 * @author ning.zhang
 * @date 2022-05-19 10:20:29
 */
@Component
public class AttendanceRecordPictureRepository extends ServiceImpl<AttendanceRecordPictureMapper, AttendanceRecordPictureEntity> {

  /**
   * 通过考勤记录ID删除勤记录照片信息
   *
   * @param recordId 考勤记录ID
   */
  public void deleteByRecordId(String recordId) {
    this.lambdaUpdate()
        .eq(AttendanceRecordPictureEntity::getRecordId, recordId)
        .remove();
  }

  /**
   * 通过考勤记录ID查询勤记录照片信息
   *
   * @param recordIds 考勤记录ID
   */
  public List<AttendanceRecordPictureEntity> findByRecordIds(List<String> recordIds) {
   return this.lambdaQuery()
        .in(AttendanceRecordPictureEntity::getRecordId, recordIds)
        .list();
  }
}
