package com.biz.crm.sfa.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordRulePlaceEntity;
import com.biz.crm.sfa.business.attendance.local.mapper.AttendanceRecordRulePlaceMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 考勤记录规则地点表的数据库访问类 {@link AttendanceRecordRulePlaceEntity}
 *
 * @author ning.zhang
 * @date 2022-06-22 14:19:48
 */
@Component
public class AttendanceRecordRulePlaceRepository extends ServiceImpl<AttendanceRecordRulePlaceMapper, AttendanceRecordRulePlaceEntity> {

  /**
   * 通过记录规则ID查询考勤记录规则地点信息
   *
   * @param recordRuleId 记录规则ID
   * @return 考勤记录规则地点信息
   */
  public List<AttendanceRecordRulePlaceEntity> findByRecordRuleId(String recordRuleId) {
   return this.lambdaQuery()
        .eq(AttendanceRecordRulePlaceEntity::getRecordRuleId, recordRuleId)
        .list();
  }
}
