package com.biz.crm.sfa.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordRuleEntity;
import com.biz.crm.sfa.business.attendance.local.mapper.AttendanceRecordRuleMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 考勤记录规则表的数据库访问类 {@link AttendanceRecordRuleEntity}
 *
 * @author ning.zhang
 * @date 2022-05-17 09:52:39
 */
@Component
public class AttendanceRecordRuleRepository extends ServiceImpl<AttendanceRecordRuleMapper, AttendanceRecordRuleEntity> {

  /**
   * 通过规则ID集合和考勤规则日期删除数据
   *
   * @param tenantCode 租户编码
   * @param ruleIds 则ID集合
   * @param ruleDate 勤规则日期
   */
  public void deleteByRuleIdsAndRuleDate(String tenantCode, List<String> ruleIds, String ruleDate) {
    this.lambdaUpdate()
        .eq(AttendanceRecordRuleEntity::getRuleDate, ruleDate)
        .eq(AttendanceRecordRuleEntity::getTenantCode, tenantCode)
        .in(AttendanceRecordRuleEntity::getRuleId, ruleIds)
        .remove();
  }

  /**
   * 通过规则ID集合和考勤规则日期查询考勤记录规则
   *
   * @param tenantCode 租户编码
   * @param ruleIds 则ID集合
   * @return 考勤记录规则
   */
  public List<AttendanceRecordRuleEntity> findByRuleIds(String tenantCode, List<String> ruleIds) {
    return this.lambdaQuery()
        .eq(AttendanceRecordRuleEntity::getTenantCode, tenantCode)
        .in(AttendanceRecordRuleEntity::getRuleId, ruleIds)
        .list();
  }
}
