package com.biz.crm.sfa.business.attendance.local.repository;

import com.biz.crm.sfa.business.attendance.local.mapper.AttendanceRecordVoMapper;
import com.biz.crm.sfa.business.attendance.sdk.dto.TodayHistoryRecordDto;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRecordVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @description: 考勤记录规则vo
 * @author: rentao
 * @date: 2022/7/21 16:23
 */
@Component
public class AttendanceRecordVoRepository {

  @Autowired
  private AttendanceRecordVoMapper attendanceRecordVoMapper;

  /**
   * 条件查询历史考勤记录信息
   *
   * @param dto 参数dto
   * @return 考勤记录信息
   */
  public List<AttendanceRecordVo> findByHistoryRecordDto(TodayHistoryRecordDto dto){
    return this.attendanceRecordVoMapper.findByHistoryRecordDto(dto);
  }
}
