package com.biz.crm.sfa.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleScopeEntity;
import com.biz.crm.sfa.business.attendance.local.mapper.AttendanceRuleScopeMapper;
import com.biz.crm.sfa.business.attendance.local.model.RuleScopeConditionModel;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 考勤规则范围表的数据库访问类 {@link AttendanceRuleScopeEntity}
 *
 * @author ning.zhang
 * @date 2022-05-05 09:44:28
 */
@Component
public class AttendanceRuleScopeRepository extends ServiceImpl<AttendanceRuleScopeMapper, AttendanceRuleScopeEntity> {

  /**
   * 通过删除考勤规则ID删除考勤规则范围
   *
   * @param ruleId 考勤规则ID
   */
  public void deleteByRuleId(String ruleId) {
    this.lambdaUpdate()
        .eq(AttendanceRuleScopeEntity::getRuleId, ruleId)
        .remove();
  }

  /**
   * 多条件查询考勤规则范围列表
   *
   * @param model 条件model
   * @return 考勤规则范围列表
   */
  public List<AttendanceRuleScopeEntity> findByRuleScopeConditionModel(RuleScopeConditionModel model) {
    return this.baseMapper.findByRuleScopeConditionModel(model);
  }
}
