package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyPictureEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceFillApplyPictureRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceFillApplyPictureService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillClockDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 补打考勤申请照片表服务实现类
 *
 * @author ning.zhang
 * @date 2022-05-25 16:21:46
 */
@Slf4j
@Service("attendanceFillApplyPictureService")
public class AttendanceFillApplyPictureServiceImpl implements AttendanceFillApplyPictureService {

  @Autowired
  private AttendanceFillApplyPictureRepository attendanceFillApplyPictureRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(AttendanceFillClockDto dto) {
    Validate.notBlank(dto.getId(), "补打卡申请记录ID不能为空");
    this.attendanceFillApplyPictureRepository.deleteByApplyId(dto.getId());
    if (CollectionUtils.isEmpty(dto.getPictureList())) {
      return;
    }
    this.updateValidation(dto);
    List<AttendanceFillApplyPictureEntity> entities = dto.getPictureList().stream().map(pictureDto -> {
      AttendanceFillApplyPictureEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(pictureDto, AttendanceFillApplyPictureEntity.class, HashSet.class, ArrayList.class);
      entity.setApplyId(dto.getId());
      entity.setTenantCode(dto.getTenantCode());
      return entity;
    }).collect(Collectors.toList());
    this.attendanceFillApplyPictureRepository.saveBatch(entities);
  }

  /**
   * 在修改attendanceFillApplyPicture模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param dto 检查对象
   */
  private void updateValidation(AttendanceFillClockDto dto) {
    dto.getPictureList().forEach(pictureDto -> {
      Validate.notBlank(pictureDto.getFileCode(), "缺失文件唯一识别号");
    });
  }
}
