package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordEntity;
import com.biz.crm.sfa.business.attendance.local.model.FillApplyConditionModel;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceFillApplyRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRepository;
import com.biz.crm.sfa.business.attendance.sdk.constant.AttendanceConstant;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillApplyPageDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType;
import com.biz.crm.sfa.business.attendance.sdk.event.AttendanceUpperDataListener;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceFillApplyVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceFillApplyVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRecordVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 补打考勤申请表Vo服务接口实现
 *
 * @author ning.zhang
 * @date 2022/5/26
 */
@Slf4j
@Service
public class AttendanceFillApplyVoServiceImpl implements AttendanceFillApplyVoService {

  @Autowired
  private AttendanceFillApplyRepository attendanceFillApplyRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private AttendanceRecordRepository attendanceRecordRepository;
  @Autowired
  private UserFeignVoService userFeignVoService;
  @Autowired
  private PositionVoService positionVoService;
  @Autowired
  private UserInfoVoService userInfoVoService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private UserVoService userVoService;
  @Autowired
  private ProcessBusinessMappingService processBusinessMappingService;
  @Autowired(required = false)
  private AttendanceUpperDataListener attendanceUpperDataListener;

  @Override
  public List<AttendanceFillApplyVo> findByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return Lists.newLinkedList();
    }
    List<AttendanceFillApplyEntity> entities = this.attendanceFillApplyRepository.findByIds(ids);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();

    }
    List<AttendanceFillApplyVo> list = (List<AttendanceFillApplyVo>) this.nebulaToolkitService.copyCollectionByBlankList(entities, AttendanceFillApplyEntity.class
        , AttendanceFillApplyVo.class, HashSet.class, ArrayList.class);
    this.buildProcessInfo(list);
    this.perfectUserInfo(list);
    return list;
  }

  @Override
  public Page<AttendanceFillApplyVo> findByConditions(Pageable pageable, AttendanceFillApplyPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new AttendanceFillApplyPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    dto.setUserNames(Sets.newHashSet(loginDetails.getAccount()));
    List<PositionVo> positionList = this.positionVoService.findByParentCode(loginDetails.getPostCode());
    if (!CollectionUtils.isEmpty(positionList)) {
      List<UserInfoVo> userList = this.userInfoVoService.findByPositionCodes(positionList.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet()));
      if (!CollectionUtils.isEmpty(userList)) {
        dto.getUserNames().addAll(userList.stream().map(UserInfoVo::getUserName).collect(Collectors.toList()));
      }
    }
    //如果搜索了关键字,需要查询关键字对应的用户集合
    if (StringUtils.isNotBlank(dto.getKeyWord())) {
      UserConditionDto userConditionDto = new UserConditionDto();
      userConditionDto.setFullName(dto.getKeyWord());
      dto.setKeyWordUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
    }
    if (StringUtils.isNotEmpty(dto.getApplyDateStart())) {
      dto.setApplyDateStart(String.format("%s %s", dto.getApplyDateStart(), AttendanceConstant.TIME_STR_000000));
    }
    if (StringUtils.isNotEmpty(dto.getApplyDateEnd())) {
      dto.setApplyDateEnd(String.format("%s %s", dto.getApplyDateEnd(), AttendanceConstant.TIME_STR_235959));
    }
    if (Objects.isNull(this.attendanceUpperDataListener)) {
      return new Page<>(pageable.getPageNumber(), pageable.getPageSize(), 0);
    }
    dto.setBusinessCode(AttendanceConstant.ATTENDANCE_FILL_CLOCK_APPLY_PROCESS_FORM_TYPE);
    Page<AttendanceFillApplyVo> entityPage = this.attendanceUpperDataListener.findByConditions(pageable, dto);
    if (CollectionUtils.isEmpty(entityPage.getRecords())) {
      return entityPage;
    }
    this.buildProcessInfo(entityPage.getRecords());
    this.perfectUserInfo(entityPage.getRecords());
    return entityPage;
  }

  @Override
  public Page<AttendanceFillApplyVo> findDetailByConditions(Pageable pageable,
                                                            AttendanceFillApplyPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new AttendanceFillApplyPageDto());
    if (StringUtils.isNotBlank(dto.getUserRealName())) {
      UserConditionDto userConditionDto = new UserConditionDto();
      userConditionDto.setFullName(dto.getUserRealName());
      dto.setUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    if (StringUtils.isNotEmpty(dto.getApplyDateStart())) {
      dto.setApplyDateStart(String.format("%s %s", dto.getApplyDateStart(), AttendanceConstant.TIME_STR_000000));
    }
    if (StringUtils.isNotEmpty(dto.getApplyDateEnd())) {
      dto.setApplyDateEnd(String.format("%s %s", dto.getApplyDateEnd(), AttendanceConstant.TIME_STR_235959));
    }
    if (Objects.isNull(this.attendanceUpperDataListener)) {
      return new Page<>(pageable.getPageNumber(), pageable.getPageSize(), 0);
    }
    dto.setBusinessCode(AttendanceConstant.ATTENDANCE_FILL_CLOCK_APPLY_PROCESS_FORM_TYPE);
    Page<AttendanceFillApplyVo> entityPage = this.attendanceUpperDataListener.findByConditions(pageable, dto);
    if (CollectionUtils.isEmpty(entityPage.getRecords())) {
      return entityPage;
    }
    this.buildProcessInfo(entityPage.getRecords());
    this.perfectRecordInfo(entityPage.getRecords());
    return entityPage;
  }

  @Override
  public List<AttendanceFillApplyVo> findByApplyCodes(List<String> applyCodes) {
    if (CollectionUtils.isEmpty(applyCodes)) {
      return Lists.newLinkedList();
    }
    FillApplyConditionModel model = new FillApplyConditionModel();
    model.setTenantCode(TenantUtils.getTenantCode());
    model.setApplyCodes(applyCodes);
    List<AttendanceFillApplyEntity> entities = this.attendanceFillApplyRepository.findByFillApplyConditionModel(model);
    List<AttendanceFillApplyVo> list = (List<AttendanceFillApplyVo>) this.nebulaToolkitService.copyCollectionByBlankList(entities, AttendanceFillApplyEntity.class
        , AttendanceFillApplyVo.class, HashSet.class, ArrayList.class);
    this.buildProcessInfo(list);
    this.perfectUserInfo(list);
    return list;
  }

  /**
   * 封装流程信息
   *
   * @param voList 待封装数据
   */
  private void buildProcessInfo(List<AttendanceFillApplyVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    //解析考勤记录
    Set<String> recordIds = voList.stream().filter(vo -> StringUtils.isNotBlank(vo.getRecordIds()))
        .flatMap(entity -> Sets.newHashSet(entity.getRecordIds().split(",")).stream()).collect(Collectors.toSet());
    List<AttendanceRecordEntity> recordEntities = this.attendanceRecordRepository.listByIds(recordIds);
    Map<String, AttendanceRecordVo> recordMap = CollectionUtils.isEmpty(recordEntities) ? Maps.newHashMap()
        : recordEntities.stream().collect(Collectors.toMap(AttendanceRecordEntity::getId, entity
        -> this.nebulaToolkitService.copyObjectByWhiteList(entity, AttendanceRecordVo.class, HashSet.class, ArrayList.class), (a, b) -> b));
    //解析审批记录
    List<String> applyCodes = voList.stream().map(AttendanceFillApplyVo::getApplyCode).collect(Collectors.toList());
    ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
    businessMappingDto.setBusinessCode(AttendanceConstant.ATTENDANCE_FILL_CLOCK_APPLY_PROCESS_FORM_TYPE);
    businessMappingDto.setBusinessNos(applyCodes);
    List<ProcessBusinessMappingVo> businessMappingVos = this.processBusinessMappingService.findMultiByByConditions(businessMappingDto);
    Map<String, ProcessBusinessVo> processMap = CollectionUtils.isEmpty(businessMappingVos) ? Maps.newHashMap() : businessMappingVos.stream()
        .collect(Collectors.toMap(ProcessBusinessMappingVo::getBusinessNo
            , t -> this.nebulaToolkitService.copyObjectByBlankList(t, ProcessBusinessVo.class, HashSet.class, ArrayList.class)
            , (a, b) -> b));
    //转换数据
    voList.forEach(vo -> {
      List<AttendanceRecordVo> recordList = Arrays.stream(vo.getRecordIds().split(",")).map(recordMap::get)
          .filter(Objects::nonNull).collect(Collectors.toList());
      vo.setRecordList(recordList);
      vo.setProcessBusiness(processMap.get(vo.getApplyCode()));
    });
  }

  /**
   * 完善补打卡申请用户信息
   *
   * @param list 补打卡申请
   */
  private void perfectUserInfo(List<AttendanceFillApplyVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Set<String> userNames = list.stream().map(AttendanceFillApplyVo::getUserName).collect(Collectors.toSet());
    List<UserVo> userVoList = this.userFeignVoService.findByUserNames(Lists.newArrayList(userNames));
    if (CollectionUtils.isEmpty(userVoList)) {
      return;
    }
    Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
    list.forEach(vo -> {
      UserVo userVo = userMap.getOrDefault(vo.getUserName(), new UserVo());
      vo.setUserRealName(userVo.getFullName());
      vo.setPositionCode(userVo.getPositionCode());
      vo.setPositionName(userVo.getPositionName());
      vo.setOrgCode(userVo.getOrgCode());
      vo.setOrgName(userVo.getOrgName());
    });
  }

  /**
   * 完善打卡记录信息
   *
   * @param list 打卡记录列表
   */
  private void perfectRecordInfo(List<AttendanceFillApplyVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    list.forEach(vo -> {
      if (CollectionUtils.isEmpty(vo.getRecordList())) {
        return;
      }
      vo.getRecordList().forEach(attendanceRecordVo -> {
        //考勤日期
        String ruleDate = attendanceRecordVo.getRuleDate();
        //打卡类型
        String clockType = attendanceRecordVo.getClockType();
        AttendanceClockType attendanceClockType = AttendanceClockType.getByDictCode(clockType);
        if (Objects.nonNull(attendanceClockType)) {
          //打卡时间
          vo.setClockType(String.format("%s (%s)", attendanceClockType.getValue(), ObjectUtils.defaultIfNull(attendanceRecordVo.getClockTime(), "")));
        }
        vo.setRuleDate(ruleDate);
      });
    });
  }
}
