/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.helper;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleEntity;
import com.biz.crm.sfa.business.attendance.local.model.RuleExecuteModel;
import com.biz.crm.sfa.business.attendance.local.model.RuleExecuteUserModel;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRuleRepository;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleExecuteDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.RuleConditionDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleScopeType;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AttendanceRuleServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(AttendanceRuleServiceHelper.class);
    @Autowired
    private AttendanceRuleRepository attendanceRuleRepository;
    @Autowired
    private OrgPositionVoService orgPositionVoService;
    @Autowired
    private UserInfoVoService userInfoVoService;
    @Autowired
    private PositionVoService positionVoService;

    public RuleExecuteModel buildRuleExecuteModel(AttendanceRuleExecuteDto dto) {
        RuleExecuteModel executeModel = new RuleExecuteModel();
        dto.setExecuteDate(StringUtils.isNotBlank((CharSequence)(dto = (AttendanceRuleExecuteDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new AttendanceRuleExecuteDto())).getExecuteDate()) ? dto.getExecuteDate() : LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        RuleConditionDto conditionDto = new RuleConditionDto();
        conditionDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        conditionDto.setTenantCode(TenantUtils.getTenantCode());
        List<AttendanceRuleEntity> ruleEntities = this.attendanceRuleRepository.findByRuleConditionDto(conditionDto);
        Validate.isTrue((!CollectionUtils.isEmpty(ruleEntities) ? 1 : 0) != 0, (String)"\u65e0\u53ef\u6267\u884c\u89c4\u5219", (Object[])new Object[0]);
        this.buildModelRuleScopeInfo(executeModel, ruleEntities);
        this.buildModelOrgUserInfo(executeModel);
        this.buildModelRuleUserInfo(executeModel);
        return executeModel;
    }

    private void buildModelRuleScopeInfo(RuleExecuteModel executeModel, List<AttendanceRuleEntity> ruleEntities) {
        executeModel.setRuleMap(Maps.newHashMap());
        executeModel.setRulePositionLevelMap(Maps.newHashMap());
        executeModel.setRuleOrgMap(Maps.newHashMap());
        ruleEntities.forEach(ruleEntity -> {
            executeModel.getRuleMap().put(ruleEntity.getId(), (AttendanceRuleEntity)((Object)ruleEntity));
            ruleEntity.getScopeList().forEach(scopeEntity -> {
                if (AttendanceRuleScopeType.ORG.getDictCode().equals(scopeEntity.getScopeType())) {
                    Set<String> orgCodes = executeModel.getRuleOrgMap().getOrDefault(scopeEntity.getRuleId(), Sets.newHashSet());
                    orgCodes.add(scopeEntity.getScopeCode());
                    executeModel.getRuleOrgMap().put(scopeEntity.getRuleId(), orgCodes);
                }
                if (AttendanceRuleScopeType.POSITION_LEVEL.getDictCode().equals(scopeEntity.getScopeType())) {
                    Set<String> positionLevelCodes = executeModel.getRulePositionLevelMap().getOrDefault(scopeEntity.getRuleId(), Sets.newHashSet());
                    positionLevelCodes.add(scopeEntity.getScopeCode());
                    executeModel.getRulePositionLevelMap().put(scopeEntity.getRuleId(), positionLevelCodes);
                }
            });
        });
    }

    private void buildModelOrgUserInfo(RuleExecuteModel executeModel) {
        Validate.isTrue((!executeModel.getRuleOrgMap().isEmpty() ? 1 : 0) != 0, (String)"\u65e0\u53ef\u6267\u884c\u89c4\u5219\u7ec4\u7ec7\u8303\u56f4", (Object[])new Object[0]);
        ArrayList orgCodes = Lists.newArrayList((Iterable)executeModel.getRuleOrgMap().values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        List splitOrgCodes = Lists.partition((List)orgCodes, (int)50);
        HashMap orgUserMap = Maps.newHashMap();
        splitOrgCodes.forEach(codes -> this.buildOrgUserMap((List<String>)codes, orgUserMap));
        executeModel.setOrgUserMap(orgUserMap);
    }

    private void buildOrgUserMap(List<String> orgCodes, Map<String, List<RuleExecuteUserModel>> orgUserMap) {
        List orgPositions = this.orgPositionVoService.findByOrgCodes(orgCodes);
        if (CollectionUtils.isEmpty((Collection)orgPositions)) {
            return;
        }
        Set orgPositionCodes = orgPositions.stream().map(OrgPositionVo::getPositionCode).collect(Collectors.toSet());
        List users = this.userInfoVoService.findByPositionCodes(orgPositionCodes);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return;
        }
        if (CollectionUtils.isEmpty(users = users.stream().filter(userInfoVo -> Boolean.TRUE.equals(userInfoVo.getPrimaryFlag())).collect(Collectors.toList()))) {
            return;
        }
        List userPositionCodes = users.stream().map(UserInfoVo::getPositionCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userPositionCodes)) {
            return;
        }
        List positions = this.positionVoService.findByIdsOrCodes((List)Lists.newLinkedList(), userPositionCodes);
        if (CollectionUtils.isEmpty((Collection)positions)) {
            return;
        }
        Map<String, PositionVo> positionMap = positions.stream().collect(Collectors.toMap(PositionVo::getPositionCode, t -> t, (a, b) -> b));
        Map positionUserMap = users.stream().filter(userInfoVo -> Objects.nonNull(positionMap.get(userInfoVo.getPositionCode()))).collect(Collectors.groupingBy(UserInfoVo::getPositionCode, Collectors.mapping(o -> {
            PositionVo positionVo = (PositionVo)positionMap.get(o.getPositionCode());
            RuleExecuteUserModel userModel = new RuleExecuteUserModel();
            userModel.setUserName(o.getUserName());
            userModel.setPositionCode(positionVo.getPositionCode());
            userModel.setPositionLevelCode(positionVo.getPositionLevelCode());
            return userModel;
        }, Collectors.toList())));
        orgPositions.stream().filter(orgPositionVo -> !CollectionUtils.isEmpty((Collection)((Collection)positionUserMap.get(orgPositionVo.getPositionCode())))).forEach(orgPositionVo -> {
            List positionUserModels = (List)positionUserMap.get(orgPositionVo.getPositionCode());
            List orgUserModels = (List)orgUserMap.get(orgPositionVo.getOrgCode());
            if (CollectionUtils.isEmpty((Collection)orgUserModels)) {
                orgUserModels = Lists.newArrayList();
            }
            orgUserModels.addAll(positionUserModels);
            orgUserMap.put(orgPositionVo.getOrgCode(), orgUserModels);
        });
    }

    private void buildModelRuleUserInfo(RuleExecuteModel executeModel) {
        HashMap ruleUserMap = Maps.newHashMap();
        if (!executeModel.getOrgUserMap().isEmpty()) {
            HashSet userNames = Sets.newHashSet();
            executeModel.getRuleOrgMap().forEach((ruleId, ordCodes) -> {
                for (String orgCode : ordCodes) {
                    this.buildRuleOrgMap(executeModel, ruleUserMap, userNames, (String)ruleId, orgCode);
                }
            });
        }
        executeModel.setRuleUserMap(ruleUserMap);
    }

    private void buildRuleOrgMap(RuleExecuteModel executeModel, Map<String, List<RuleExecuteUserModel>> ruleUserMap, Set<String> userNames, String ruleId, String orgCode) {
        List<RuleExecuteUserModel> userModels = executeModel.getOrgUserMap().get(orgCode);
        if (CollectionUtils.isEmpty(userModels)) {
            return;
        }
        List executeUsers = userModels.stream().filter(userModel -> {
            Set<String> positionCodes = executeModel.getRulePositionLevelMap().get(ruleId);
            return !CollectionUtils.isEmpty(positionCodes) && positionCodes.contains(userModel.getPositionLevelCode());
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(executeUsers)) {
            executeUsers = userModels.stream().filter(model -> !userNames.contains(model.getUserName())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(executeUsers)) {
            return;
        }
        ArrayList mapUserModelList = ruleUserMap.get(ruleId);
        if (CollectionUtils.isEmpty(mapUserModelList)) {
            mapUserModelList = Lists.newArrayList();
            ruleUserMap.put(ruleId, mapUserModelList);
        }
        mapUserModelList.addAll(executeUsers);
        userNames.addAll(executeUsers.stream().map(RuleExecuteUserModel::getUserName).collect(Collectors.toSet()));
    }
}

