/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordPictureEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordPictureRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRecordPictureService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceClockDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceRecordPictureService")
public class AttendanceRecordPictureServiceImpl
implements AttendanceRecordPictureService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceRecordPictureServiceImpl.class);
    @Autowired
    private AttendanceRecordPictureRepository attendanceRecordPictureRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(AttendanceClockDto dto) {
        Validate.notBlank((CharSequence)dto.getRecordId(), (String)"\u8003\u52e4\u8bb0\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.attendanceRecordPictureRepository.deleteByRecordId(dto.getRecordId());
        if (CollectionUtils.isEmpty((Collection)dto.getPictureList())) {
            return;
        }
        this.updateValidation(dto);
        List entities = dto.getPictureList().stream().map(pictureDto -> {
            AttendanceRecordPictureEntity entity = (AttendanceRecordPictureEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(pictureDto, AttendanceRecordPictureEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setRecordId(dto.getRecordId());
            entity.setTenantCode(TenantUtils.getTenantCode());
            return entity;
        }).collect(Collectors.toList());
        this.attendanceRecordPictureRepository.saveBatch(entities);
    }

    private void updateValidation(AttendanceClockDto dto) {
        dto.getPictureList().forEach(pictureDto -> Validate.notBlank((CharSequence)pictureDto.getFileCode(), (String)"\u7f3a\u5931\u6587\u4ef6\u552f\u4e00\u8bc6\u522b\u53f7", (Object[])new Object[0]));
    }
}

