/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordRuleEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleTimeEntity;
import com.biz.crm.sfa.business.attendance.local.model.RuleExecuteModel;
import com.biz.crm.sfa.business.attendance.local.model.RuleExecuteUserModel;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRuleRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRecordService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillClockDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceRecordService")
public class AttendanceRecordServiceImpl
implements AttendanceRecordService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceRecordServiceImpl.class);
    @Autowired
    private AttendanceRecordRepository attendanceRecordRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private AttendanceRecordRuleRepository attendanceRecordRuleRepository;
    @Autowired
    private UserFeignVoService userFeignVoService;

    @Override
    @Transactional
    public void update(RuleExecuteModel executeModel, AttendanceRecordRuleEntity recordRuleEntity) {
        Validate.notNull((Object)executeModel, (String)"\u7f3a\u5931\u89c4\u5219\u6267\u884c\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)recordRuleEntity), (String)"\u7f3a\u5931\u8bb0\u5f55\u89c4\u5219\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)executeModel.getRuleMap().get(recordRuleEntity.getRuleId())), (String)"\u7f3a\u5931\u8003\u52e4\u89c4\u5219\u4fe1\u606f", (Object[])new Object[0]);
        List<AttendanceRecordEntity> recordEntities = this.buildRecordEntity(executeModel, recordRuleEntity);
        if (CollectionUtils.isEmpty(recordEntities)) {
            return;
        }
        List<AttendanceRecordEntity> haveUseRecordEntities = this.attendanceRecordRepository.findByRuleDateAndUsedStatus(TenantUtils.getTenantCode(), recordRuleEntity.getRuleDate(), BooleanEnum.TRUE.getCapital());
        if (!CollectionUtils.isEmpty(haveUseRecordEntities)) {
            Set userNames = haveUseRecordEntities.stream().map(AttendanceRecordEntity::getUserName).collect(Collectors.toSet());
            recordEntities = recordEntities.stream().filter(entity -> !userNames.contains(entity.getUserName())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(recordEntities)) {
            return;
        }
        List splitEntities = Lists.partition(recordEntities, (int)100);
        splitEntities.forEach(entities -> this.attendanceRecordRepository.saveBatch((Collection)entities));
    }

    @Override
    public List<AttendanceRecordEntity> findByAttendanceFillClockDto(AttendanceFillClockDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getBeginTime(), dto.getEndTime()})) {
            return Lists.newLinkedList();
        }
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        dto.setUserName(loginDetails.getAccount());
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<AttendanceRecordEntity> recordEntities = this.attendanceRecordRepository.findByAttendanceFillClockDto(dto);
        if (CollectionUtils.isEmpty(recordEntities)) {
            return Lists.newLinkedList();
        }
        Set recordRuleIds = recordEntities.stream().map(AttendanceRecordEntity::getRecordRuleId).collect(Collectors.toSet());
        List ruleEntities = this.attendanceRecordRuleRepository.listByIds(recordRuleIds);
        if (CollectionUtils.isEmpty((Collection)ruleEntities)) {
            return Lists.newLinkedList();
        }
        Map<String, AttendanceRecordRuleEntity> ruleEntityMap = ruleEntities.stream().collect(Collectors.toMap(UuidEntity::getId, t -> t, (a, b) -> b));
        recordEntities.forEach(entity -> {
            AttendanceRecordRuleEntity recordRuleEntity = (AttendanceRecordRuleEntity)((Object)((Object)ruleEntityMap.get(entity.getRecordRuleId())));
            if (AttendanceRuleType.FREE_TIME.getDictCode().equals(recordRuleEntity.getRuleType())) {
                entity.setRuleClockTime("");
            }
        });
        if (recordEntities.size() > 1) {
            AttendanceRecordEntity recordEntity = new AttendanceRecordEntity();
            recordEntity.setClockType(AttendanceClockType.ON_AND_OFF_WORK.getDictCode());
            recordEntities.add(recordEntity);
        }
        return recordEntities;
    }

    private List<AttendanceRecordEntity> buildRecordEntity(RuleExecuteModel executeModel, AttendanceRecordRuleEntity recordRuleEntity) {
        ArrayList recordEntities = Lists.newArrayList();
        AttendanceRuleEntity ruleEntity = executeModel.getRuleMap().get(recordRuleEntity.getRuleId());
        List<AttendanceRuleTimeEntity> timeList = ruleEntity.getTimeList();
        List<RuleExecuteUserModel> userModels = executeModel.getRuleUserMap().get(recordRuleEntity.getRuleId());
        if (CollectionUtils.isEmpty(userModels)) {
            return Lists.newLinkedList();
        }
        List userNames = userModels.stream().filter(ruleExecuteUserModel -> StringUtils.isNotBlank((CharSequence)ruleExecuteUserModel.getUserName())).map(RuleExecuteUserModel::getUserName).collect(Collectors.toList());
        List userVos = this.userFeignVoService.findByUserNames(userNames);
        HashMap<String, UserVo> userVoMap = new HashMap<String, UserVo>();
        if (!CollectionUtils.isEmpty((Collection)userVos)) {
            userVoMap.putAll(userVos.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b)));
        }
        userModels.forEach(userModel -> timeList.forEach(ruleTimeEntity -> {
            UserVo userVo = (UserVo)userVoMap.get(userModel.getUserName());
            AttendanceRecordEntity onWorkEntity = new AttendanceRecordEntity();
            onWorkEntity.setTenantCode(recordRuleEntity.getTenantCode());
            onWorkEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            onWorkEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            onWorkEntity.setRuleId(recordRuleEntity.getRuleId());
            onWorkEntity.setRecordRuleId(recordRuleEntity.getId());
            onWorkEntity.setRuleTimeId(ruleTimeEntity.getId());
            onWorkEntity.setClockStatus(AttendanceClockStatus.NONE.getDictCode());
            onWorkEntity.setUserName(userModel.getUserName());
            if (Objects.nonNull(userVo)) {
                onWorkEntity.setUserRealName(userVo.getFullName());
                onWorkEntity.setOrgCode(userVo.getOrgName());
                onWorkEntity.setOrgName(userVo.getOrgName());
                onWorkEntity.setPostCode(userVo.getPositionCode());
                onWorkEntity.setPostName(userVo.getPositionName());
            }
            onWorkEntity.setUsedStatus(BooleanEnum.FALSE.getCapital());
            onWorkEntity.setRuleDate(recordRuleEntity.getRuleDate());
            onWorkEntity.setRuleCode(recordRuleEntity.getRuleCode());
            AttendanceRecordEntity offWorkEntity = (AttendanceRecordEntity)((Object)((Object)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)onWorkEntity, AttendanceRecordEntity.class, HashSet.class, ArrayList.class, new String[0]))));
            onWorkEntity.setClockType(AttendanceClockType.ON_WORK.getDictCode());
            offWorkEntity.setClockType(AttendanceClockType.OFF_WORK.getDictCode());
            onWorkEntity.setRuleClockTime(ruleTimeEntity.getOnWorkTime());
            onWorkEntity.setRuleClockStartTime(ruleTimeEntity.getOnWorkClockStartTime());
            onWorkEntity.setRuleClockEndTime(ruleTimeEntity.getOnWorkClockEndTime());
            offWorkEntity.setRuleClockTime(ruleTimeEntity.getOffWorkTime());
            offWorkEntity.setRuleClockStartTime(ruleTimeEntity.getOffWorkClockStartTime());
            offWorkEntity.setRuleClockEndTime(ruleTimeEntity.getOffWorkClockEndTime());
            recordEntities.add(onWorkEntity);
            recordEntities.add(offWorkEntity);
        }));
        return recordEntities;
    }
}

