/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleScopeEntity;
import com.biz.crm.sfa.business.attendance.local.model.RuleScopeConditionModel;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRuleRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRuleScopeRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRuleScopeService;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleScopeDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.RuleConditionDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleScopeType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceRuleScopeService")
public class AttendanceRuleScopeServiceImpl
implements AttendanceRuleScopeService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceRuleScopeServiceImpl.class);
    @Autowired
    private AttendanceRuleScopeRepository attendanceRuleScopeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AttendanceRuleRepository attendanceRuleRepository;

    @Override
    @Transactional
    public void update(AttendanceRuleDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u8003\u52e4\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.attendanceRuleScopeRepository.deleteByRuleId(dto.getId());
        if (CollectionUtils.isEmpty((Collection)dto.getScopeList())) {
            return;
        }
        this.updateValidation(dto);
        List entities = dto.getScopeList().stream().map(scopeDto -> {
            AttendanceRuleScopeEntity entity = (AttendanceRuleScopeEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(scopeDto, AttendanceRuleScopeEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setRuleId(dto.getId());
            entity.setContainsChild(BooleanEnum.TRUE.getCapital());
            return entity;
        }).collect(Collectors.toList());
        this.attendanceRuleScopeRepository.saveBatch(entities);
    }

    @Override
    public void validateScope(AttendanceRuleDto dto) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getScopeList())) {
            return;
        }
        ArrayList orgCodes = Lists.newArrayList();
        ArrayList positionLevelCodes = Lists.newArrayList();
        dto.getScopeList().forEach(scopeVo -> {
            if (AttendanceRuleScopeType.ORG.getDictCode().equals(scopeVo.getScopeType())) {
                orgCodes.add(scopeVo.getScopeCode());
            }
            if (AttendanceRuleScopeType.POSITION_LEVEL.getDictCode().equals(scopeVo.getScopeType())) {
                positionLevelCodes.add(scopeVo.getScopeCode());
            }
        });
        RuleConditionDto conditionDto = new RuleConditionDto();
        conditionDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        conditionDto.setTenantCode(TenantUtils.getTenantCode());
        conditionDto.setExcludeIds((List)Lists.newArrayList((Object[])new String[]{dto.getId()}));
        conditionDto.setOrgCodes((List)orgCodes);
        List<AttendanceRuleEntity> sameOrgRules = this.attendanceRuleRepository.findByRuleConditionDto(conditionDto);
        if (CollectionUtils.isEmpty(sameOrgRules)) {
            return;
        }
        List<String> ruleCodes = sameOrgRules.stream().map(AttendanceRuleEntity::getRuleCode).collect(Collectors.toList());
        RuleScopeConditionModel ruleScopeModel = new RuleScopeConditionModel();
        ruleScopeModel.setRuleCodes(ruleCodes);
        ruleScopeModel.setScopeType(AttendanceRuleScopeType.POSITION_LEVEL.getDictCode());
        ruleScopeModel.setTenantCode(TenantUtils.getTenantCode());
        List<AttendanceRuleScopeEntity> scopeEntities = this.attendanceRuleScopeRepository.findByRuleScopeConditionModel(ruleScopeModel);
        if (!CollectionUtils.isEmpty((Collection)positionLevelCodes)) {
            Map<String, AttendanceRuleScopeEntity> scopeEntityMap = scopeEntities.stream().collect(Collectors.toMap(AttendanceRuleScopeEntity::getScopeCode, t -> t, (a, b) -> b));
            positionLevelCodes.forEach(positionLevelCode -> {
                AttendanceRuleScopeEntity scopeEntity = (AttendanceRuleScopeEntity)((Object)((Object)scopeEntityMap.get(positionLevelCode)));
                Validate.isTrue((boolean)Objects.isNull((Object)scopeEntity), (String)String.format("\u804c\u4f4d\u91cd\u590d\u6dfb\u52a0,\u51b2\u7a81\u89c4\u5219\u7f16\u7801:%s", Objects.isNull((Object)scopeEntity) ? "" : scopeEntity.getRuleCode()), (Object[])new Object[0]);
            });
        } else {
            Map<String, AttendanceRuleScopeEntity> scopeEntityMap = scopeEntities.stream().collect(Collectors.toMap(AttendanceRuleScopeEntity::getRuleId, t -> t, (a, b) -> b));
            sameOrgRules.forEach(ruleEntity -> {
                AttendanceRuleScopeEntity scopeEntity = (AttendanceRuleScopeEntity)((Object)((Object)scopeEntityMap.get(ruleEntity.getRuleCode())));
                if (Objects.nonNull((Object)scopeEntity)) {
                    return;
                }
                ArrayList inWorkingDays = Lists.newArrayList((Object[])dto.getWorkingDay().split(","));
                ArrayList vaWorkingDays = Lists.newArrayList((Object[])ruleEntity.getWorkingDay().split(","));
                inWorkingDays.retainAll(vaWorkingDays);
                Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)inWorkingDays), (String)String.format("\u7ec4\u7ec7\u91cd\u590d\u6dfb\u52a0,\u51b2\u7a81\u89c4\u5219\u7f16\u7801:%s", ruleEntity.getRuleCode()), (Object[])new Object[0]);
            });
        }
    }

    private void updateValidation(AttendanceRuleDto dto) {
        Boolean haveOrg = Boolean.FALSE;
        for (AttendanceRuleScopeDto scopeDto : dto.getScopeList()) {
            Validate.notBlank((CharSequence)scopeDto.getScopeCode(), (String)"\u7f3a\u5931\u8303\u56f4\u7f16\u7801", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)scopeDto.getScopeType(), (String)"\u7f3a\u5931\u8303\u56f4\u7c7b\u578b", (Object[])new Object[0]);
            if (!AttendanceRuleScopeType.ORG.getDictCode().equals(scopeDto.getScopeType())) continue;
            haveOrg = Boolean.TRUE;
        }
        Validate.isTrue((boolean)haveOrg, (String)"\u7f3a\u5931\u6253\u5361\u7ec4\u7ec7", (Object[])new Object[0]);
        this.validateScope(dto);
    }
}

