/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordRuleEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRuleEntity;
import com.biz.crm.sfa.business.attendance.local.model.RuleExecuteModel;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRuleRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRuleRepository;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRecordRuleService;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRulePlaceService;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRuleScopeService;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRuleService;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRuleSpecialDateService;
import com.biz.crm.sfa.business.attendance.local.service.AttendanceRuleTimeService;
import com.biz.crm.sfa.business.attendance.local.service.helper.AttendanceRuleServiceHelper;
import com.biz.crm.sfa.business.attendance.sdk.constant.AttendanceConstant;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRuleExecuteDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceRulePageDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceElectronFenceType;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleEffectiveType;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleType;
import com.biz.crm.sfa.business.attendance.sdk.event.AttendanceRuleEventListener;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceRuleService")
public class AttendanceRuleServiceImpl
implements AttendanceRuleService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceRuleServiceImpl.class);
    @Autowired(required=false)
    private List<AttendanceRuleEventListener> listeners;
    @Autowired
    private AttendanceRuleRepository attendanceRuleRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private AttendanceRulePlaceService attendanceRulePlaceService;
    @Autowired
    private AttendanceRuleScopeService attendanceRuleScopeService;
    @Autowired
    private AttendanceRuleTimeService attendanceRuleTimeService;
    @Autowired
    private AttendanceRuleSpecialDateService attendanceRuleSpecialDateService;
    @Autowired
    private AttendanceRuleServiceHelper attendanceRuleServiceHelper;
    @Autowired
    private AttendanceRecordRuleService attendanceRecordRuleService;
    @Autowired
    private AttendanceRecordRuleRepository attendanceRecordRuleRepository;

    @Override
    @Transactional
    public AttendanceRuleEntity create(AttendanceRuleDto dto) {
        this.createValidation(dto);
        AttendanceRuleEntity entity = (AttendanceRuleEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, AttendanceRuleEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setRuleEffective(AttendanceRuleEffectiveType.TOMORROW.getDictCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setRuleCode((String)this.generateCodeService.generateCode("AR", 1).get(0));
        this.attendanceRuleRepository.save((Object)entity);
        dto.setId(entity.getId());
        this.bindRelationData(dto);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            AttendanceRuleVo vo = (AttendanceRuleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, AttendanceRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setRuleCode(entity.getRuleCode());
            this.listeners.forEach(listener -> listener.onCreate(vo));
        }
        return entity;
    }

    @Override
    @Transactional
    public AttendanceRuleEntity update(AttendanceRuleDto dto) {
        this.updateValidation(dto);
        List<AttendanceRuleEntity> entities = this.attendanceRuleRepository.findByIds(Lists.newArrayList((Object[])new String[]{dto.getId()}));
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u8003\u52e4\u89c4\u5219\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        AttendanceRuleEntity updateEntity = (AttendanceRuleEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, AttendanceRuleEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.attendanceRuleRepository.updateById((Object)updateEntity);
        this.bindRelationData(dto);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            AttendanceRuleVo oldVo = (AttendanceRuleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entities.get(0), AttendanceRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
            AttendanceRuleVo newVo = (AttendanceRuleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, AttendanceRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
            newVo.setRuleCode(oldVo.getRuleCode());
            this.listeners.forEach(listener -> listener.onUpdate(oldVo, newVo));
        }
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.attendanceRuleRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.attendanceRuleRepository.updateDelFlagByIds(ids);
        Map<String, AttendanceRuleEntity> ruleEntityMap = entities.stream().collect(Collectors.toMap(UuidEntity::getId, t -> t, (a, b) -> b));
        List<AttendanceRecordRuleEntity> recordRuleEntities = this.attendanceRecordRuleRepository.findByRuleIds(TenantUtils.getTenantCode(), ids);
        if (!CollectionUtils.isEmpty(recordRuleEntities)) {
            recordRuleEntities.forEach(entity -> {
                AttendanceRuleEntity ruleEntity = (AttendanceRuleEntity)((Object)((Object)ruleEntityMap.get(entity.getRuleId())));
                throw new IllegalArgumentException(String.format("\u89c4\u5219[%s]\u5df2\u751f\u6210\u8003\u52e4\u6570\u636e,\u65e0\u6cd5\u5220\u9664", ruleEntity.getRuleCode()));
            });
        }
        if (!CollectionUtils.isEmpty(this.listeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, AttendanceRuleEntity.class, AttendanceRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onDelete(voList));
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<AttendanceRuleEntity> entities = this.attendanceRuleRepository.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.attendanceRuleRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        entities.forEach(ruleEntity -> {
            AttendanceRuleDto ruleDto = (AttendanceRuleDto)this.nebulaToolkitService.copyObjectByBlankList((Object)ruleEntity, AttendanceRuleDto.class, HashSet.class, ArrayList.class, new String[0]);
            this.attendanceRuleScopeService.validateScope(ruleDto);
        });
        if (!CollectionUtils.isEmpty(this.listeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, AttendanceRuleEntity.class, AttendanceRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onEnable(voList));
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.attendanceRuleRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.attendanceRuleRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        this.attendanceRecordRuleService.deleteByRuleIdsAndRuleDate(ids, LocalDate.now().format(AttendanceConstant.YYYY_MM_DD));
        if (!CollectionUtils.isEmpty(this.listeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, AttendanceRuleEntity.class, AttendanceRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onDisable(voList));
        }
    }

    @Override
    public Page<AttendanceRuleEntity> findByConditions(Pageable pageable, AttendanceRulePageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (AttendanceRulePageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new AttendanceRulePageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.attendanceRuleRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional
    public void execute(AttendanceRuleExecuteDto dto) {
        RuleExecuteModel executeModel = this.attendanceRuleServiceHelper.buildRuleExecuteModel(dto);
        executeModel.setExecuteDate(StringUtils.isNotBlank((CharSequence)dto.getExecuteDate()) ? dto.getExecuteDate() : LocalDate.now().format(AttendanceConstant.YYYY_MM_DD));
        this.attendanceRecordRuleService.create(executeModel);
    }

    @Override
    @DynamicTaskService(cornExpression="0 0 0 * * ?", taskDesc="\u8003\u52e4\u89c4\u5219\u6267\u884c\u5b9a\u65f6\u4efb\u52a1")
    public void executeTask() {
        AttendanceRuleExecuteDto dto = new AttendanceRuleExecuteDto();
        dto.setExecuteDate(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        RuleExecuteModel executeModel = this.attendanceRuleServiceHelper.buildRuleExecuteModel(dto);
        executeModel.setExecuteDate(dto.getExecuteDate());
        this.attendanceRecordRuleService.create(executeModel);
    }

    private void bindRelationData(AttendanceRuleDto dto) {
        this.attendanceRulePlaceService.update(dto);
        this.attendanceRuleScopeService.update(dto);
        this.attendanceRuleTimeService.update(dto);
        this.attendanceRuleSpecialDateService.update(dto);
    }

    private void createValidation(AttendanceRuleDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getRuleName(), (String)"\u7f3a\u5931\u89c4\u5219\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRuleType(), (String)"\u7f3a\u5931\u89c4\u5219\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWorkingDay(), (String)"\u7f3a\u5931\u5de5\u4f5c\u65e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSyncHoliday(), (String)"\u7f3a\u5931\u662f\u5426\u540c\u6b65\u8282\u5047\u65e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getClockPhotograph(), (String)"\u7f3a\u5931\u6253\u5361\u662f\u5426\u9700\u8981\u62cd\u7167", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOffWorkClockType(), (String)"\u7f3a\u5931\u4e0b\u73ed\u6253\u5361\u7c7b\u578b", (Object[])new Object[0]);
        if (AttendanceRuleType.STATIC.getDictCode().equals(dto.getRuleType())) {
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getTimeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8003\u52e4\u65f6\u95f4", (Object[])new Object[0]);
        }
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getScopeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8003\u52e4\u8303\u56f4", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)dto.getPlaceList())) {
            Validate.notBlank((CharSequence)dto.getElectronFenceType(), (String)"\u7f3a\u5931\u6253\u5361\u8303\u56f4\u7c7b\u578b", (Object[])new Object[0]);
        } else {
            dto.setElectronFenceType(AttendanceElectronFenceType.NONE.getDictCode());
        }
        Validate.isTrue((dto.getRuleName().length() <= 100 ? 1 : 0) != 0, (String)"\u89c4\u5219\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(100)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        AttendanceRuleEntity ruleEntity = this.attendanceRuleRepository.findByRuleName(dto.getTenantCode(), dto.getRuleName());
        Validate.isTrue((boolean)Objects.isNull((Object)ruleEntity), (String)String.format("\u5df2\u5b58\u5728\u8003\u52e4\u89c4\u5219[%s]", dto.getRuleName()), (Object[])new Object[0]);
    }

    private void updateValidation(AttendanceRuleDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRuleName(), (String)"\u7f3a\u5931\u89c4\u5219\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRuleType(), (String)"\u7f3a\u5931\u89c4\u5219\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWorkingDay(), (String)"\u7f3a\u5931\u5de5\u4f5c\u65e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSyncHoliday(), (String)"\u7f3a\u5931\u662f\u5426\u540c\u6b65\u8282\u5047\u65e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getClockPhotograph(), (String)"\u7f3a\u5931\u6253\u5361\u662f\u5426\u9700\u8981\u62cd\u7167", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOffWorkClockType(), (String)"\u7f3a\u5931\u4e0b\u73ed\u6253\u5361\u7c7b\u578b", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getScopeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8003\u52e4\u8303\u56f4", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)dto.getPlaceList())) {
            Validate.notBlank((CharSequence)dto.getElectronFenceType(), (String)"\u7f3a\u5931\u6253\u5361\u8303\u56f4\u7c7b\u578b", (Object[])new Object[0]);
        } else {
            dto.setElectronFenceType(AttendanceElectronFenceType.NONE.getDictCode());
        }
        Validate.isTrue((dto.getRuleName().length() <= 100 ? 1 : 0) != 0, (String)"\u89c4\u5219\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(100)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        AttendanceRuleEntity ruleEntity = this.attendanceRuleRepository.findByRuleName(dto.getTenantCode(), dto.getRuleName());
        Validate.isTrue((Objects.isNull((Object)ruleEntity) || ruleEntity.getRuleName().equals(dto.getRuleName()) ? 1 : 0) != 0, (String)String.format("\u5df2\u5b58\u5728\u8003\u52e4\u89c4\u5219[%s]", dto.getRuleName()), (Object[])new Object[0]);
    }
}

