/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.attendance.local.service.observer;

import com.biz.crm.sfa.business.attendance.local.entity.AttendanceFillApplyEntity;
import com.biz.crm.sfa.business.attendance.local.entity.AttendanceRecordEntity;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceFillApplyRepository;
import com.biz.crm.sfa.business.attendance.local.repository.AttendanceRecordRepository;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockStatus;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendancePlaceStatus;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AttendanceFillApplyProcessCompleteListener
implements ProcessCompleteListener {
    @Autowired
    private AttendanceFillApplyRepository attendanceFillApplyRepository;
    @Autowired
    private AttendanceRecordRepository attendanceRecordRepository;

    public String getBusinessCode() {
        return "attendance_fill_clock_apply";
    }

    @Transactional
    public void onProcessComplete(ProcessStatusDto dto) {
        if (!dto.getBusinessCode().equals("attendance_fill_clock_apply")) {
            return;
        }
        AttendanceFillApplyEntity applyEntity = this.attendanceFillApplyRepository.findByApplyCode(dto.getBusinessNo(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)applyEntity), (String)"\u8865\u6253\u5361\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        if (ProcessStatusEnum.PASS.getDictCode().equals(dto.getProcessStatus())) {
            HashSet recordIds = Sets.newHashSet((Object[])applyEntity.getRecordIds().split(","));
            List recordEntities = this.attendanceRecordRepository.listByIds(recordIds);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)recordEntities) ? 1 : 0) != 0, (String)"\u6b64\u7533\u8bf7\u627e\u4e0d\u5230\u9700\u8981\u6267\u884c\u7684\u6253\u5361\u4fe1\u606f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff01", (Object[])new Object[0]);
            Iterator iterator = recordEntities.iterator();
            while (iterator.hasNext()) {
                AttendanceRecordEntity recordEntity;
                recordEntity.setRemark(StringUtils.isBlank((CharSequence)(recordEntity = (AttendanceRecordEntity)((Object)iterator.next())).getRemark()) ? "\u8865\u6253\u5361" : String.format("%s;%s", recordEntity.getRemark(), "\u8865\u6253\u5361"));
                recordEntity.setClockStatus(AttendanceClockStatus.OK.getDictCode());
                recordEntity.setClockPlaceStatus(AttendancePlaceStatus.OK.getDictCode());
                recordEntity.setClockTime(recordEntity.getRuleClockTime());
            }
            this.attendanceRecordRepository.updateBatchById(recordEntities);
        }
    }
}

