package com.biz.crm.sfa.business.attendance.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import java.time.format.DateTimeFormatter;

/**
 * 考勤常量
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class AttendanceConstant {

  /**
   * 12:00:00
   */
  public static final String TIME_STR_120000 = "12:00:00";
  /**
   * 每天最早的时刻
   */
  public static final String TIME_STR_000000 = "00:00:00";

  /**
   * 每天最晚的时刻
   */
  public static final String TIME_STR_235959 = "23:59:59";
  /**
   * 时间日期格式 yyyy-MM-dd HH:mm:ss
   */
  public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
  /**
   * 时间日期格式 yyyy-MM-dd
   */
  public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
  /**
   * 时间日期格式 HH:mm:ss
   */
  public static final DateTimeFormatter HH_MM_SS = DateTimeFormatter.ofPattern("HH:mm:ss");
  /**
   * 时间日期格式 yyyy-MM
   */
  public static final DateTimeFormatter YYYY_MM = DateTimeFormatter.ofPattern("yyyy-MM");
  /**
   * 时间日期格式 yyyy
   */
  public static final DateTimeFormatter YYYY = DateTimeFormatter.ofPattern("yyyy");

  /**
   * 同步拜访计划
   */
  public static final String VISIT_PLAN_PLACE = "同步拜访计划";

  /**
   * 补打卡当月多少号之前可以修改上月打卡数据
   */
  public static final Integer FILL_CLOCK_CAN_UPDATE_LAST_MONTH_DAY_NUM = 8;


  /**
   * 考勤补打卡申请发起流程来源类型
   */
  public static final String ATTENDANCE_FILL_CLOCK_APPLY_PROCESS_FORM_TYPE = "attendance_fill_clock_apply";

  /**
   * 考勤补打卡申请发起流程key
   */
  public static final String ATTENDANCE_FILL_CLOCK_APPLY_PROCESS_KEY = "fill_clock_apply_process001";

  /**
   * 考勤补打卡申请发起流程名称
   */
  public static final String ATTENDANCE_FILL_CLOCK_APPLY_PROCESS_NAME = "考勤补打卡审批流程";
}
