package com.biz.crm.sfa.business.attendance.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 考勤补打卡申请分页Dto
 *
 * @author ning.zhang
 * @date 2022/5/26
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceFillApplyPageDto", description = "考勤补打卡申请分页Dto")
public class AttendanceFillApplyPageDto extends TenantDto {

  /**
   * 人员账号集合
   */
  @ApiModelProperty(value = "人员账号集合", hidden = true)
  private Set<String> userNames;

  /**
   * 关键字对应人员账号集合
   */
  @ApiModelProperty(value = "关键字对应人员账号集合", hidden = true)
  private Set<String> keyWordUserNames;

  /**
   * 关键字
   */
  @ApiModelProperty("关键字")
  private String keyWord;

  /**
   * 申请日期开始 (yyyy-MM-dd)
   */
  @ApiModelProperty("申请日期开始 (yyyy-MM-dd HH:mm:ss)")
  private String applyDateStart;

  /**
   * 申请日期结束 (yyyy-MM-dd)
   */
  @ApiModelProperty("申请日期结束 (yyyy-MM-dd HH:mm:ss)")
  private String applyDateEnd;

  /**
   * 补打卡开始时间开始 (yyyy-MM-dd)
   */
  @ApiModelProperty("补打卡开始时间开始 (yyyy-MM-dd)")
  private String beginTimeStart;

  /**
   * 补打卡开始时间结束 (yyyy-MM-dd)
   */
  @ApiModelProperty("补打卡开始时间结束 (yyyy-MM-dd)")
  private String beginTimeEnd;

  /**
   * 补打卡结束时间开始 (yyyy-MM-dd)
   */
  @ApiModelProperty("补打卡结束时间开始 (yyyy-MM-dd)")
  private String endTimeStart;

  /**
   * 补打卡结束时间结束 (yyyy-MM-dd)
   */
  @ApiModelProperty("补打卡结束时间结束 (yyyy-MM-dd)")
  private String endTimeEnd;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String processStatus;

  /**
   * 补打卡年月
   */
  @ApiModelProperty("补打卡年月")
  private String yearMonth;

  /**
   * 姓名
   */
  @ApiModelProperty("姓名")
  private String userRealName;

  /**
   * 账号
   */
  @ApiModelProperty("账号")
  private String userName;

  /**
   * 岗位
   */
  @ApiModelProperty("岗位")
  private String positionName;

  /**
   * 岗位
   */
  @ApiModelProperty("岗位编码")
  private String positionCode;

  /**
   * 组织
   */
  @ApiModelProperty("组织")
  private String orgName;

  /**
   * 组织
   */
  @ApiModelProperty("组织编码")
  private String orgCode;
}
