package com.biz.crm.sfa.business.attendance.sdk.dto;

import com.biz.crm.business.common.sdk.dto.FileDto;
import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.dto.WorkflowFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * 考勤补打卡Dto
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceFillClockDto", description = "考勤补打卡Dto")
public class AttendanceFillClockDto extends WorkflowFlagOpDto {

  /**
   * 开始时间
   */
  @ApiModelProperty(value = "开始时间")
  private String beginTime;

  /**
   * 结束时间
   */
  @ApiModelProperty(value = "结束时间")
  private String endTime;

  /**
   * 异常打卡记录ID集合
   */
  @ApiModelProperty(value = "异常打卡记录ID集合")
  private Set<String> recordIds;

  /**
   * 申请原因
   */
  @ApiModelProperty(value = "申请原因")
  private String applyReason;

  /**
   * 申请照片
   */
  @ApiModelProperty("申请照片")
  private List<FileDto> pictureList;

  /**
   * 用户账号
   */
  @ApiModelProperty(value = "用户账号", hidden = true)
  private String userName;

  /**
   * 申请日期(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty(value = "申请日期(yyyy-MM-dd HH:mm:ss)", hidden = true)
  private String applyDate;

  /**
   * 申请编码
   */
  @ApiModelProperty(value = "申请编码", hidden = true)
  private String applyCode;
}
