package com.biz.crm.sfa.business.attendance.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleNoWorkAbideVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 考勤规则Dto
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceRuleDto", description = "考勤规则Dto")
public class AttendanceRuleDto extends TenantDto {

  /**
   * 规则名称
   */
  @ApiModelProperty("规则名称")
  private String ruleName;

  /**
   * 规则类型(static:固定时间上下班规则;free_time:自由时间上下班规则)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleType
   */
  @ApiModelProperty("规则类型(static:固定时间上下班规则;free_time:自由时间上下班规则)")
  private String ruleType;

  /**
   * 打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceElectronFenceType
   */
  @ApiModelProperty("打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)")
  private String electronFenceType;

  /**
   * 工作日(1:星期一;2:星期二;3:星期三;4:星期四;5:星期五;6:星期六;7:星期日)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceWorkingDayType
   */
  @ApiModelProperty("工作日(1:星期一;2:星期二;3:星期三;4:星期四;5:星期五;6:星期六;7:星期日)")
  private String workingDay;

  /**
   * 是否同步节假日-节假日期间不用打卡(Y:同步;N:不同步)
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否同步节假日-节假日期间不用打卡(Y:同步;N:不同步)")
  private String syncHoliday;

  /**
   * 打卡是否需要拍照(Y:需要;N:不需要)
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("打卡是否需要拍照(Y:需要;N:不需要)")
  private String clockPhotograph;

  /**
   * 下班打卡类型(no_sign:下班不需要打卡;goto_work_required:下班需要打卡，且必须打上班卡才能打下班卡;goto_work_no_required:下班需要打卡，无需打上班卡，就能打下班卡)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceOffWorkClockType
   */
  @ApiModelProperty("下班打卡类型(no_sign:下班不需要打卡;goto_work_required:下班需要打卡，且必须打上班卡才能打下班卡;goto_work_no_required:下班需要打卡，无需打上班卡，就能打下班卡)")
  private String offWorkClockType;

  /**
   * 规则生效类型(now:立即生效;tomorrow:明日生效)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleEffectiveType
   */
  @ApiModelProperty("规则生效类型(now:立即生效;tomorrow:明日生效)")
  private String ruleEffective;

  /**
   * 考勤地点信息
   */
  @ApiModelProperty("考勤地点信息")
  private List<AttendanceRulePlaceDto> placeList;

  /**
   * 考勤范围信息
   */
  @ApiModelProperty("考勤范围信息")
  private List<AttendanceRuleScopeDto> scopeList;

  /**
   * 考勤时间信息
   */
  @ApiModelProperty("考勤时间信息")
  private List<AttendanceRuleTimeDto> timeList;

  /**
   * 考勤特殊日期信息
   */
  @ApiModelProperty("考勤特殊日期信息")
  private List<AttendanceRuleSpecialDateDto> specialDateList;

  /**
   * 非工作日模块遵守考勤规则关联信息(上层非工作日模块关联信息)
   */
  @ApiModelProperty("非工作日模块遵守考勤规则关联信息(上层非工作日模块关联信息)")
  private List<AttendanceRuleNoWorkAbideVo> noWorkAbideInfoList;
}
