package com.biz.crm.sfa.business.attendance.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 考勤规则时间Dto
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@Getter
@Setter
@ApiModel(value = "AttendanceRuleTimeDto", description = "考勤规则时间Dto")
public class AttendanceRuleTimeDto {

  /**
   * 时间段序号
   */
  @ApiModelProperty(value = "时间段序号", hidden = true)
  private String timeNo;

  /**
   * 上班时间
   */
  @ApiModelProperty("上班时间")
  private String onWorkTime;

  /**
   * 下班时间
   */
  @ApiModelProperty("下班时间")
  private String offWorkTime;

  /**
   * 上班打卡开始时间
   */
  @ApiModelProperty("上班打卡开始时间")
  private String onWorkClockStartTime;

  /**
   * 上班打卡结束时间
   */
  @ApiModelProperty("上班打卡结束时间")
  private String onWorkClockEndTime;

  /**
   * 下班打卡开始时间
   */
  @ApiModelProperty("下班打卡开始时间")
  private String offWorkClockStartTime;

  /**
   * 下班打卡结束时间
   */
  @ApiModelProperty("下班打卡结束时间")
  private String offWorkClockEndTime;
}
