package com.biz.crm.sfa.business.attendance.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 考勤规则枚举类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum AttendanceRuleType {

  /**
   * 固定时间上下班规则
   */
  STATIC("static", "static", "固定时间上下班规则", "1"),
  /**
   * 自由时间上下班规则
   */
  FREE_TIME("free_time", "free_time", "自由时间上下班规则", "2");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
