package com.biz.crm.sfa.business.attendance.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 考勤打卡或者不打卡类型枚举
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum AttendanceSignOrNonType {

  /**
   * 工作日打卡
   */
  WORKDAY_SIGN("workday_sign", "workday_sign", "工作日打卡", "1"),
  /**
   * 特殊日期打卡
   */
  SPECIAL_DAY_SIGN("special_day_sign", "special_day_sign", "特殊日期打卡", "2"),
  /**
   * 非工作日不打卡
   */
  WORK_DAY_NO_SIGN("work_day_no_sign", "work_day_no_sign", "非工作日不打卡", "3"),
  /**
   * 特殊日期不打卡
   */
  SPECIAL_DAY_NO_SIGN("special_day_no_sign", "special_day_no_sign", "特殊日期不打卡", "4"),
  /**
   * 节假日不打卡
   */
  HOLIDAY_NO_SIGN("holiday_no_sign", "holiday_no_sign", "节假日不打卡", "5"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
