package com.biz.crm.sfa.business.attendance.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 考勤特殊日期枚举类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum AttendanceSpecialDateType {

  /**
   * 必须打卡日期
   */
  MUST_CLOCK("must_clock", "must_clock", "必须打卡日期", "1"),
  /**
   * 不用打卡日期
   */
  NOT_CLOCK("not_clock", "not_clock", "不用打卡日期", "2"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
