package com.biz.crm.sfa.business.attendance.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 考勤工作日类型枚举类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum AttendanceWorkingDayType {

  /**
   * 星期一
   */
  MONDAY("monday", "1", "星期一", "1"),
  /**
   * 星期二
   */
  TUESDAY("tuesday", "2", "星期二", "2"),
  /**
   * 星期三
   */
  WEDNESDAY("wednesday", "3", "星期三", "3"),
  /**
   * 星期四
   */
  THURSDAY("thursday", "4", "星期四", "4"),
  /**
   * 星期五
   */
  FRIDAY("friday", "5", "星期五", "5"),
  /**
   * 星期六
   */
  SATURDAY("saturday", "6", "星期六", "6"),
  /**
   * 星期日
   */
  SUNDAY("sunday", "7", "星期日", "7"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
