package com.biz.crm.sfa.business.attendance.sdk.event;

import com.biz.crm.sfa.business.attendance.sdk.dto.RuleNoWorkAbideDataDto;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleNoWorkAbideDataVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleNoWorkAbideVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleVo;

import java.util.List;
import java.util.Set;

/**
 * 考勤规则事件通知
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
public interface AttendanceRuleEventListener {

  /**
   * 当考勤规则新增时触发
   *
   * @param vo 考勤规则信息
   */
  void onCreate(AttendanceRuleVo vo);

  /**
   * 当考勤规则修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  void onUpdate(AttendanceRuleVo oldVo, AttendanceRuleVo newVo);

  /**
   * 当考勤规则禁用时触发
   *
   * @param voList 禁用vo信息
   */
  void onDisable(List<AttendanceRuleVo> voList);

  /**
   * 当考勤规则启用时触发
   *
   * @param voList 禁用vo信息
   */
  void onEnable(List<AttendanceRuleVo> voList);

  /**
   * 当考勤规则删除时触发
   *
   * @param voList 删除vo信息
   */
  void onDelete(List<AttendanceRuleVo> voList);


  /**
   * 根据规则编码集合获取非工作日上层模块遵守规则关联配置
   *
   * @param ruleCodes 规则编码集合
   * @return 非工作日上层模块遵守规则关联配置
   */
  List<AttendanceRuleNoWorkAbideVo> onRequestByRuleCodes(Set<String> ruleCodes);

  /**
   * 获取非工作日上层模块遵守规则关联数据
   *
   * @param dto 参数dto
   * @return 非工作日上层模块遵守规则关联数据
   */
  List<AttendanceRuleNoWorkAbideDataVo> onRequestByRuleNoWorkAbideDataDto(RuleNoWorkAbideDataDto dto);
}
