package com.biz.crm.sfa.business.attendance.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceFillApplyPageDto;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceFillApplyVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 补打考勤申请表Vo服务接口
 *
 * @author ning.zhang
 * @date 2022/5/26
 */
public interface AttendanceFillApplyVoService {

  /**
   * 通过ID集合查询补打卡申请信息
   *
   * @param ids ID集合
   * @return 补打卡申请信息
   */
  List<AttendanceFillApplyVo> findByIds(List<String> ids);

  /**
   * 补打卡申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceFillApplyVo> 补打卡申请分页信息
   */
  Page<AttendanceFillApplyVo> findByConditions(Pageable pageable, AttendanceFillApplyPageDto dto);


  /**
   * 后台补打卡申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<AttendanceFillApplyVo> 补打卡申请分页信息
   */
  Page<AttendanceFillApplyVo> findDetailByConditions(Pageable pageable, AttendanceFillApplyPageDto dto);

}
