package com.biz.crm.sfa.business.attendance.sdk.service;

import com.biz.crm.sfa.business.attendance.sdk.dto.AttendanceClockDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.AttendancePlaceStatusDto;
import com.biz.crm.sfa.business.attendance.sdk.dto.TodayHistoryRecordDto;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRecordVo;

import java.util.List;

/**
 * 考勤记录Vo服务接口类
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
public interface AttendanceRecordVoService {

  /**
   * 移动端-获取当前用户考勤打卡信息
   *
   * @param dto 参数dto
   * @return 考勤打卡信息
   */
  AttendanceRecordVo findByAttendanceClockDto(AttendanceClockDto dto);

  /**
   * 移动端-当前用户考勤打卡
   *
   * @param dto 参数dto
   */
  void updateByAttendanceClockDto(AttendanceClockDto dto);

  /**
   * 移动端-查询今日历史考勤记录信息
   *
   * @param dto 参数dto
   * @return 考勤记录信息
   */
  List<AttendanceRecordVo> findByTodayHistoryRecordDto(TodayHistoryRecordDto dto);

  /**
   * 通过考勤记录ID集合查询打卡详情列表
   *
   * @param ids 考勤记录ID集合
   * @return 考勤记录列表
   */
  List<AttendanceRecordVo> findByIds(List<String> ids);

  /**
   * 移动端-查询考勤地点状态信息
   *
   * @param dto 参数dto
   * @return 考勤地点状态信息
   */
  AttendanceRecordVo findByAttendancePlaceStatusDto(AttendancePlaceStatusDto dto);


  /**
   * 移动端-查询今日历史考勤记录信息
   *
   * @param dto 参数dto
   * @return 考勤记录信息
   */
  List<AttendanceRecordVo> findByHistoryRecordDto(TodayHistoryRecordDto dto);
}
