package com.biz.crm.sfa.business.attendance.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 非工作日考勤规则遵守数据Vo
 *
 * @author ning.zhang
 * @date 2022/5/19
 */
@Data
@ApiModel(value = "AttendanceRuleNoWorkAbideDataVo", description = "非工作日考勤规则遵守数据Vo")
public class AttendanceRuleNoWorkAbideDataVo implements Serializable{

  private static final long serialVersionUID = -2913633452415136455L;

  /**
   * 关联模块key
   */
  @ApiModelProperty(value = "关联模块key")
  private String key;

  /**
   * 规则编码
   */
  @ApiModelProperty(value = "规则编码")
  private String ruleCode;

  /**
   * 当前是否存在遵守此规则的数据-用于获取当前上层模块遵守此规则的数据(例如当前时间存在遵守此规则的加班数据等)(Y:是;N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty(value = "当前时间是否存在遵守此规则的数据-用于获取当前上层模块遵守此规则的数据(例如当前时间存在遵守此规则的加班数据等)(Y:是;N:否)", hidden = true)
  private String currentHaveAbideData;
}
