package com.biz.crm.sfa.business.attendance.sdk.vo;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 非工作日考勤规则遵守Vo
 *
 * @author ning.zhang
 * @date 2022/5/19
 */
@Data
@ApiModel(value = "AttendanceRuleNoWorkAbideVo", description = "非工作日考勤规则遵守Vo")
public class AttendanceRuleNoWorkAbideVo implements Serializable{

  private static final long serialVersionUID = 8597721254755767462L;
  /**
   * 关联模块key
   */
  @ApiModelProperty(value = "关联模块key")
  private String key;

  /**
   * 是否遵守此规则(Y:是;N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty(value = "是否遵守此规则(Y:是;N:否)")
  private String abideFlag;

  /**
   * 规则编码
   */
  @ApiModelProperty(value = "规则编码")
  private String ruleCode;

  /**
   * 附加数据
   */
  @ApiModelProperty(value = "附加数据")
  private JSONObject additionalData;

}
