package com.biz.crm.sfa.business.attendance.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 考勤规则地点Vo
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceRulePlaceVo", description = "考勤规则地点Vo")
public class AttendanceRulePlaceVo extends UuidOpVo{

  private static final long serialVersionUID = 3769301012515840080L;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  private String ruleId;

  /**
   * 地点序号
   */
  @ApiModelProperty("地点序号")
  private String placeNo;

  /**
   * 地点名称
   */
  @ApiModelProperty("地点名称")
  private String placeName;

  /**
   * 地点经度
   */
  @ApiModelProperty("地点经度")
  private BigDecimal placeLongitude;

  /**
   * 地点纬度
   */
  @ApiModelProperty("地点纬度")
  private BigDecimal placeLatitude;

  /**
   * 打卡类型(on_and_off_work:上下班打卡,on_work:上班打卡,off_work:下班打卡)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType
   */
  @ApiModelProperty("打卡类型(on_and_off_work:上下班打卡,on_work:上班打卡,off_work:下班打卡)")
  private String clockType;

  /**
   * 地点范围((100:100米,300:300米,500:500米))
   */
  @ApiModelProperty("地点范围((100:100米,300:300米,500:500米))")
  private Integer placeRange;
}
