package com.biz.crm.sfa.business.attendance.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 考勤规则特殊日期Vo
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceRulePlaceVo", description = "考勤规则特殊日期Vo")
public class AttendanceRuleSpecialDateVo extends UuidOpVo {

  private static final long serialVersionUID = 5611323825678321753L;

  /**
   * 规则ID
   */
  @ApiModelProperty("规则ID")
  private String ruleId;

  /**
   * 特殊日期类型 (must_clock:必须打卡日期;not_clock:不用打卡日期)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceSpecialDateType
   */
  @ApiModelProperty("特殊日期类型 (must_clock:必须打卡日期;not_clock:不用打卡日期)")
  private String specialDateType;

  /**
   * 特殊日期
   */
  @ApiModelProperty("特殊日期")
  private String specialDate;
}
