package com.biz.crm.sfa.business.attendance.sdk.dto;

import com.biz.crm.business.common.sdk.dto.FileDto;
import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 考勤打卡Dto
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceClockDto", description = "考勤打卡Dto")
public class AttendanceClockDto extends TenantDto {

  /**
   * 打卡类型(on_work:上班打卡,off_work:下班打卡)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType
   */
  @ApiModelProperty(name = "打卡类型(on_work:上班打卡,off_work:下班打卡)", required = true)
  private String clockType;

  /**
   * 考勤记录ID(打卡传递)
   */
  @ApiModelProperty("考勤记录ID(打卡传递)")
  private String recordId;

  /**
   * 打卡地点(打卡传递)
   */
  @ApiModelProperty("打卡地点(打卡传递)")
  private String clockPlace;

  /**
   * 打卡地点经度(打卡传递)
   */
  @ApiModelProperty("打卡地点经度(打卡传递)")
  private BigDecimal clockLongitude;

  /**
   * 打卡地点地点纬度(打卡传递)
   */
  @ApiModelProperty("打卡地点地点纬度(打卡传递)")
  private BigDecimal clockLatitude;

  /**
   * 考勤照片(打卡传递)
   */
  @ApiModelProperty("考勤照片(打卡传递)")
  private List<FileDto> pictureList;

  /**
   * 备注
   */
  @ApiModelProperty("备注(打卡传递)")
  private String remark;
}
