package com.biz.crm.sfa.business.attendance.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 考勤打卡地点状态Dto
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendancePlaceStatusDto", description = "考勤打卡地点状态Dto")
public class AttendancePlaceStatusDto extends TenantDto {

  /**
   * 考勤记录ID
   */
  @ApiModelProperty("考勤记录ID")
  private String recordId;

  /**
   * 打卡地点
   */
  @ApiModelProperty("打卡地点")
  private String clockPlace;

  /**
   * 打卡地点经度
   */
  @ApiModelProperty("打卡地点经度")
  private BigDecimal clockLongitude;

  /**
   * 打卡地点地点纬度(
   */
  @ApiModelProperty("打卡地点地点纬度")
  private BigDecimal clockLatitude;

}
