package com.biz.crm.sfa.business.attendance.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 考勤规则地点Dto
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@Getter
@Setter
@ApiModel(value = "AttendanceRulePlaceDto", description = "考勤规则地点Dto")
public class AttendanceRulePlaceDto {

  /**
   * 地点序号
   */
  @ApiModelProperty(value = "地点序号",hidden = true)
  private String placeNo;

  /**
   * 地点名称
   */
  @ApiModelProperty("地点名称")
  private String placeName;

  /**
   * 地点经度
   */
  @ApiModelProperty("地点经度")
  private BigDecimal placeLongitude;

  /**
   * 地点纬度
   */
  @ApiModelProperty("地点纬度")
  private BigDecimal placeLatitude;

  /**
   * 打卡类型(on_and_off_work:上下班打卡,on_work:上班打卡,off_work:下班打卡)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceClockType
   */
  @ApiModelProperty("打卡类型(on_and_off_work:上下班打卡,on_work:上班打卡,off_work:下班打卡)")
  private String clockType;

  /**
   * 地点范围((100:100米,300:300米,500:500米))
   */
  @ApiModelProperty("地点范围((100:100米,300:300米,500:500米))")
  private Integer placeRange;
}
