package com.biz.crm.sfa.business.attendance.sdk.dto;

import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleScopeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 考勤规则范围Dto
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@Getter
@Setter
@ApiModel(value = "AttendanceRuleScopeDto", description = "考勤规则范围Dto")
public class AttendanceRuleScopeDto {

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  private String scopeCode;

  /**
   * 范围类型(org:组织;position_level:职位级别)
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleScopeType
   */
  @ApiModelProperty("范围类型")
  private String scopeType;

}
