package com.biz.crm.sfa.business.attendance.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 考勤规则特殊日期Dto
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@Getter
@Setter
@ApiModel(value = "AttendanceRuleSpecialDateDto", description = "考勤规则特殊日期Dto")
public class AttendanceRuleSpecialDateDto {

  /**
   * 特殊日期类型 (must_clock:必须打卡日期;not_clock:不用打卡日期)
   *
   * @see com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceSpecialDateType
   */
  @ApiModelProperty("特殊日期类型 (must_clock:必须打卡日期;not_clock:不用打卡日期)")
  private String specialDateType;

  /**
   * 特殊日期
   */
  @ApiModelProperty("特殊日期")
  private String specialDate;
}
